/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.Contents;
import org.modeshape.web.client.grid.BooleanField;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrProperty;

public class Properties
extends TabGrid<PropertyRecord, JcrProperty> {
    private final Contents contents;

    public Properties(Contents contents) {
        super("Properties");
        this.contents = contents;
    }

    public void show(JcrNode node) {
        this.setValues(node.getProperties());
    }

    protected PropertyRecord[] records() {
        PropertyRecord[] records = new PropertyRecord[100];
        for (int i = 0; i < records.length; ++i) {
            records[i] = new PropertyRecord();
        }
        return records;
    }

    @Override
    protected HLayout tableHeader() {
        HLayout header = new HLayout();
        header.setHeight(30);
        header.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Name</b>");
        name.setWidth(150);
        Label type = new Label("<b>Type</b>");
        type.setWidth(150);
        Label visibility = new Label("<b>Protected</b>");
        visibility.setWidth(100);
        Label mvalue = new Label("<b>Multivalue</b>");
        mvalue.setWidth(100);
        Label value = new Label("<b>Value</b>");
        value.setWidth100();
        header.addMember((Canvas)name);
        header.addMember((Canvas)type);
        header.addMember((Canvas)visibility);
        header.addMember((Canvas)mvalue);
        header.addMember((Canvas)value);
        return header;
    }

    @Override
    protected HLayout toolBar() {
        HLayout header = new HLayout();
        header.setBackgroundColor("#ffffff");
        header.setAlign(Alignment.LEFT);
        header.setDefaultLayoutAlign(Alignment.LEFT);
        header.setLayoutAlign(Alignment.LEFT);
        header.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        header.setLayoutAlign(VerticalAlignment.CENTER);
        header.setHeight(30);
        HLayout panel = new HLayout();
        panel.setAlign(Alignment.RIGHT);
        panel.setWidth100();
        panel.setDefaultLayoutAlign(Alignment.RIGHT);
        panel.setLayoutAlign(Alignment.RIGHT);
        panel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        Button addMixinButton = new Button();
        addMixinButton.setTitle("Add mixin");
        addMixinButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Properties.this.contents.addMixin();
            }
        });
        Button removeMixinButton = new Button();
        removeMixinButton.setTitle("Remove mixin");
        removeMixinButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Properties.this.contents.removeMixin();
            }
        });
        Button editPropertyButton = new Button();
        editPropertyButton.setTitle("Edit property");
        editPropertyButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Properties.this.contents.setProperty();
            }
        });
        header.addMember((Canvas)panel);
        panel.addMember((Canvas)new TabGrid.Strut(this, 10));
        panel.addMember((Canvas)addMixinButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)removeMixinButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)editPropertyButton);
        return header;
    }

    @Override
    protected void updateRecord(int pos, PropertyRecord record, JcrProperty value) {
        record.setValue(value);
    }

    protected class PropertyRecord
    extends HLayout {
        private Label name = new Label();
        private Label type = new Label();
        private BooleanField isProtected = new BooleanField();
        private BooleanField isMultiple = new BooleanField();
        private Label value = new Label();

        public PropertyRecord() {
            this.setStyleName("grid");
            this.setHeight(30);
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setIcon("icons/sprocket.png");
            this.name.setStyleName("text");
            this.name.setWidth(150);
            this.type.setWidth(150);
            this.type.setStyleName("text");
            this.isProtected.setWidth(100);
            this.isMultiple.setWidth(100);
            this.value.setWidth100();
            this.value.setStyleName("text");
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.type);
            this.addMember((Canvas)this.isProtected);
            this.addMember((Canvas)this.isMultiple);
            this.addMember((Canvas)this.value);
        }

        private void setValue(JcrProperty property) {
            this.name.setContents(property.getName());
            this.type.setContents(property.getType());
            this.isProtected.setValue(property.isProtected());
            this.isMultiple.setValue(property.isMultiValue());
            this.value.setContents(property.getValue());
        }
    }
}

