/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Img;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.AdminView;
import org.modeshape.web.client.Contents;
import org.modeshape.web.client.Footer;
import org.modeshape.web.client.HtmlHistory;
import org.modeshape.web.client.JcrService;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.JcrURL;
import org.modeshape.web.client.NodeTypeView;
import org.modeshape.web.client.QueryPanel;
import org.modeshape.web.client.RepositoriesView;
import org.modeshape.web.client.RepositoryInfo;
import org.modeshape.web.client.RepositoryNameView;
import org.modeshape.web.client.ToolBar;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.shared.JcrRepositoryDescriptor;
import org.modeshape.web.shared.RepositoryName;

public class Console
implements EntryPoint,
ValueChangeHandler<String> {
    protected final JcrServiceAsync jcrService = (JcrServiceAsync)GWT.create(JcrService.class);
    private final VLayout mainForm = new VLayout();
    protected JcrURL jcrURL = new JcrURL();
    protected HtmlHistory htmlHistory = new HtmlHistory();
    private ToolBar toolBar;
    private RepositoryNameView repositoryNamePanel = new RepositoryNameView(this);
    private ViewPort viewPort;
    private RepositoriesView repos;
    private Contents contents;
    private RepositoryInfo repositoryInfo = new RepositoryInfo(this, this.viewPort, null);
    private NodeTypeView nodeTypes;
    private QueryPanel queryView;
    private AdminView adminView;
    private static Img loadingImg = new Img("loading.gif");
    public static HLayout disabledHLayout = new HLayout();

    public void onModuleLoad() {
        this.jcrService.getRequestedURI(new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                SC.say((String)("Error" + caught.getMessage()));
            }

            public void onSuccess(String result) {
                Console.this.jcrURL.parse(result);
                Console.this.testCredentials();
            }
        });
    }

    private void testCredentials() {
        this.jcrService.getUserName(new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String name) {
                Console.this.showMainForm(name);
            }
        });
    }

    public void init() {
        String path = this.jcrURL.getPath();
        if (path == null) {
            path = "/";
        }
        this.repos.select(this.jcrURL.getRepository(), this.jcrURL.getWorkspace(), path, true);
    }

    protected void updateUserName(String userName) {
        this.toolBar.setUserName(userName);
    }

    public String repository() {
        return this.repositoryNamePanel.repository();
    }

    public void showMainForm(String userName) {
        this.mainForm.setLayoutMargin(Integer.valueOf(5));
        this.mainForm.setWidth100();
        this.mainForm.setHeight100();
        this.mainForm.setBackgroundColor("#FFFFFF");
        this.viewPort = new ViewPort(this.jcrService);
        this.mainForm.setAlign(Alignment.CENTER);
        this.repos = new RepositoriesView(this, this.jcrService, this.viewPort);
        this.contents = new Contents(this, this.jcrService, this.viewPort);
        this.nodeTypes = new NodeTypeView(this.jcrService, this.viewPort);
        this.queryView = new QueryPanel(this, this.jcrService, this.viewPort);
        this.adminView = new AdminView(this, this.jcrService, this.viewPort);
        this.toolBar = new ToolBar(this);
        this.toolBar.setUserName(userName);
        this.mainForm.addMember((Canvas)this.toolBar);
        this.mainForm.addMember((Canvas)this.repositoryNamePanel);
        this.mainForm.addMember((Canvas)this.viewPort);
        this.mainForm.addMember((Canvas)new VLayout());
        this.mainForm.addMember((Canvas)new Strut(30));
        this.mainForm.addMember((Canvas)new Footer());
        if (this.jcrURL.getRepository() != null && this.jcrURL.getRepository().length() > 0) {
            this.init();
        } else {
            this.repos.load();
        }
        this.htmlHistory.addValueChangeHandler(this);
        this.mainForm.draw();
    }

    public void save() {
        this.jcrService.save(this.contents.repository(), this.contents.workspace(), new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
            }
        });
    }

    protected Contents contents() {
        return this.contents;
    }

    protected void showLoadingIcon() {
        disabledHLayout.setSize("100%", "100%");
        disabledHLayout.setStyleName("disabledBackgroundStyle");
        disabledHLayout.show();
        loadingImg.setSize("100px", "100px");
        loadingImg.setTop(this.mainForm.getHeight() / 2);
        loadingImg.setLeft(this.mainForm.getWidth() / 2);
        loadingImg.show();
        loadingImg.bringToFront();
    }

    protected void hideLoadingIcon() {
        loadingImg.hide();
        disabledHLayout.hide();
    }

    protected void showRepo(String name) {
        this.repositoryNamePanel.show(name);
    }

    protected void hideRepo() {
        this.repositoryNamePanel.hide();
    }

    public void updateRepository(String repository, boolean changeHistory) {
        this.jcrURL.setRepository(repository);
        if (changeHistory) {
            this.htmlHistory.newItem(this.jcrURL.toString(), false);
        }
    }

    public void updateWorkspace(String workspace, boolean changeHistory) {
        this.jcrURL.setWorkspace(workspace);
        if (changeHistory) {
            this.htmlHistory.newItem(this.jcrURL.toString(), false);
        }
    }

    public void updatePath(String path, boolean changeHistory) {
        this.jcrURL.setPath(path);
        if (changeHistory) {
            this.htmlHistory.newItem(this.jcrURL.toString(), false);
        }
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.jcrURL.parse2((String)event.getValue());
        this.repos.select(this.jcrURL.getRepository(), this.jcrURL.getWorkspace(), this.jcrURL.getPath(), false);
    }

    public void showRepositoryInfo() {
        this.showLoadingIcon();
        this.jcrService.repositoryInfo(this.repos.getSelected(), new AsyncCallback<JcrRepositoryDescriptor>(){

            public void onFailure(Throwable caught) {
                Console.this.hideLoadingIcon();
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(JcrRepositoryDescriptor result) {
                Console.this.hideLoadingIcon();
                Console.this.repositoryInfo.show(result);
                Console.this.viewPort.display(Console.this.repositoryInfo);
            }
        });
    }

    public void showRepositories() {
        this.repos.load();
    }

    public void showRepositories(Collection<RepositoryName> names) {
        this.repos.show(names);
        this.viewPort.display(this.repos);
        this.hideRepo();
    }

    public void showNodeTypes() {
        this.nodeTypes.show(this.repos.getSelected());
    }

    public void showContent() {
        this.init();
    }

    public void showQuery() {
        this.queryView.init();
    }

    public void showAdmin() {
        this.viewPort.display(this.adminView);
    }

    protected void showContent(String repository, String workspace, String path, boolean changeHistory) {
        this.contents.show(repository, workspace, path, changeHistory);
        this.showRepo(repository);
        this.viewPort.display(this.contents);
        this.updateRepository(repository, changeHistory);
    }

    protected void showContent(String repository, boolean changeHistory) {
        this.contents.show(repository, changeHistory);
        this.showRepo(repository);
        this.viewPort.display(this.contents);
        this.updateRepository(repository, changeHistory);
    }

    protected void display(View view) {
        this.viewPort.display(view);
    }

    private class Strut
    extends VLayout {
        public Strut(int size) {
            this.setHeight(size);
        }
    }
}

