/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Date;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.RemoteException;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.client.grid.AccessList;
import org.modeshape.web.client.grid.Children;
import org.modeshape.web.client.grid.Properties;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.client.grid.TabsetGrid;
import org.modeshape.web.shared.Acl;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.Policy;

public class Contents
extends View {
    public static final int CHILDREN_PAGE = 0;
    public static final int PROPERTIES_PAGE = 1;
    public static final int ACL_PAGE = 2;
    private static final String ROOT_PATH = "/";
    private Console console;
    private JcrServiceAsync jcrService;
    private String repository;
    private JcrNode node;
    private String path;
    private ComboBoxItem workspaceComboBox = new ComboBoxItem();
    private PathLabel pathLabel = new PathLabel();
    private Children children = new Children(this);
    private Properties properties = new Properties(this);
    private AccessList accessList = new AccessList(this);
    private TabsetGrid mainGrid = new TabsetGrid(new String[]{"Children", "Properties", "Access list"}, new TabGrid[]{this.children, this.properties, this.accessList});
    private Button saveButton;

    public Contents(final Console console, JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.console = console;
        this.jcrService = jcrService;
        Canvas text = new Canvas();
        text.setContents("ModeShape is a distributed, hierarchical, transactional, and consistent data store with support for queries, full-text search, events, versioning, references, and flexible and dynamic schemas. It is very fast, highly available, extremely scalable, and it is 100% open source and written in Java. Clients use the JSR-283 standard Java API for content repositories (aka, JCR) or ModeShape's REST API, and can query content through JDBC and SQL.");
        text.setWidth100();
        text.setAutoHeight();
        text.setStyleName("caption");
        this.addMember(text);
        this.addMember((Canvas)new Spacer(20));
        DynamicForm form = new DynamicForm();
        form.setFields(new FormItem[]{this.workspaceComboBox});
        this.workspaceComboBox.setTitle("Workspace");
        this.workspaceComboBox.addChangedHandler(new ChangedHandler(){

            public void onChanged(ChangedEvent event) {
                Contents.this.show(Contents.this.repository(), (String)event.getValue(), Contents.ROOT_PATH, true);
            }
        });
        VLayout wsPanel = new VLayout();
        wsPanel.addMember((Canvas)form);
        wsPanel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        wsPanel.setLayoutAlign(VerticalAlignment.CENTER);
        HLayout panel = new HLayout();
        panel.addMember((Canvas)wsPanel);
        panel.setStyleName("viewport");
        panel.setHeight(45);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        panel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        HLayout buttonPanel = new HLayout();
        buttonPanel.setWidth100();
        this.saveButton = new Button();
        this.saveButton.disable();
        this.saveButton.setTitle("Save");
        this.saveButton.setIcon("icons/save.png");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                console.save();
                Contents.this.saveButton.disable();
            }
        });
        panel.addMember((Canvas)buttonPanel);
        this.addMember((Canvas)panel);
        panel.addMember((Canvas)this.saveButton);
        HLayout spacer = new HLayout();
        spacer.setWidth(5);
        panel.addMember((Canvas)spacer);
        VLayout strut = new VLayout();
        strut.setHeight(20);
        this.addMember((Canvas)strut);
        this.addMember((Canvas)this.pathLabel);
        this.addMember((Canvas)this.mainGrid);
    }

    public JcrServiceAsync jcrService() {
        return this.jcrService;
    }

    private void showLoadIcon() {
        this.pathLabel.setVisible(false);
        this.mainGrid.setVisible(false);
        this.console.showLoadingIcon();
    }

    private void hideLoadIcon() {
        this.pathLabel.setVisible(true);
        this.mainGrid.setVisible(true);
        this.console.hideLoadingIcon();
    }

    public void show(String repository, boolean changeHistory) {
        this.repository = repository;
        this.refreshWorkspacesAndReloadNode(null, ROOT_PATH, changeHistory);
    }

    public void show(String repository, String workspace, String path, boolean changeHistory) {
        this.repository = repository;
        this.refreshWorkspacesAndReloadNode(null, path, changeHistory);
    }

    private void refreshWorkspacesAndReloadNode(final String name, final String path, final boolean changeHistory) {
        this.showLoadIcon();
        this.jcrService.getWorkspaces(this.repository, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                Contents.this.hideLoadIcon();
                RemoteException e = (RemoteException)caught;
                SC.say((String)caught.getMessage());
                if (e.code() == 1) {
                    Contents.this.console.showRepositories();
                }
            }

            public void onSuccess(String[] workspaces) {
                Contents.this.workspaceComboBox.setValueMap(workspaces);
                if (name != null) {
                    Contents.this.workspaceComboBox.setValue(name);
                } else if (workspaces.length > 0) {
                    Contents.this.workspaceComboBox.setValue(workspaces[0]);
                }
                Contents.this.getAndDisplayNode(path, changeHistory);
                Contents.this.hideLoadIcon();
            }
        });
    }

    public void getAndDisplayNode(final String path, final boolean changeHistory) {
        this.showLoadIcon();
        this.jcrService.node(this.repository(), this.workspace(), path, new AsyncCallback<JcrNode>(){

            public void onFailure(Throwable caught) {
                Contents.this.hideLoadIcon();
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(JcrNode node) {
                Contents.this.displayNode(node, 0);
                Contents.this.console.updateWorkspace(Contents.this.workspace(), changeHistory);
                Contents.this.console.updatePath(path, changeHistory);
                Contents.this.hideLoadIcon();
            }
        });
    }

    private void displayNode(JcrNode node, int page) {
        this.node = node;
        this.path = node.getPath();
        this.pathLabel.display(node.getPath());
        this.children.show(node);
        this.properties.show(node);
        this.accessList.show(node);
        this.viewPort().display(this);
        this.mainGrid.showTab(page);
    }

    public void export(String name, boolean skipBinary, boolean noRecurse) {
        this.jcrService.export(this.repository, this.workspace(), this.path(), name, true, true, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void importXML(String name, int option) {
        this.jcrService.importXML(this.repository, this.workspace(), this.path(), name, option, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void removeNode() {
        final String parent = this.parent(this.path());
        this.jcrService.removeNode(this.repository(), this.workspace(), this.path(), new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.saveButton.enable();
                Contents.this.getAndDisplayNode(parent, true);
            }
        });
    }

    public void addMixin(String name) {
        this.jcrService.addMixin(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void removeMixin(String name) {
        this.jcrService.removeMixin(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void setNodeProperty(JcrNode node, String name, Boolean value) {
        this.jcrService.setProperty(node, name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void setNodeProperty(JcrNode node, String name, Date value) {
        this.jcrService.setProperty(node, name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void setNodeProperty(JcrNode node, String name, String value) {
        this.jcrService.setProperty(node, name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    protected void addNode(String name, String primaryType) {
        this.jcrService.addNode(this.repository(), this.workspace(), this.path(), name, primaryType, new AsyncCallback<JcrNode>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(JcrNode node) {
                Contents.this.displayNode(node, 1);
                Contents.this.saveButton.enable();
            }
        });
    }

    protected void renameNode(String name) {
        this.jcrService.renameNode(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.getAndDisplayNode(Contents.this.path(), false);
                Contents.this.saveButton.enable();
            }
        });
    }

    public void addAccessList(String name) {
        Acl acl = this.node.getAcl();
        if (acl == null) {
            acl = new Acl();
            this.node.setAcl(acl);
        }
        Policy policy = new Policy();
        policy.setPrincipal(name);
        policy.add(JcrPermission.ALL);
        acl.addPolicy(policy);
        this.accessList.show();
        this.saveButton.enable();
    }

    public void updateAccessList(String principal, JcrPermission permission, boolean enabled) {
        this.jcrService.updateAccessList(this.repository, this.workspace(), this.path(), principal, permission, enabled, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void removeAccessList(String name) {
        this.node.getAccessList().remove(name);
        this.accessList.show();
    }

    public void applyAccessList() {
        this.jcrService.updateAccessList(this.repository(), this.workspace(), this.path(), this.node.getAccessList(), new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public String repository() {
        return this.repository;
    }

    public String workspace() {
        return this.workspaceComboBox.getValueAsString();
    }

    public JcrNode node() {
        return this.node;
    }

    public String path() {
        return this.path == null ? ROOT_PATH : this.path;
    }

    private String parent(String path) {
        if (path == null) {
            return ROOT_PATH;
        }
        if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
            return ROOT_PATH;
        }
        return path;
    }

    private class Spacer
    extends VLayout {
        public Spacer(int size) {
            this.setHeight(size);
        }
    }

    private class PathLabel
    extends HLayout {
        private Label[] segments = new Label[50];
        private Label[] separators = new Label[50];

        public PathLabel() {
            this.setHeight(30);
            Label path = new Label();
            path.setAutoWidth();
            path.setContents("<b>Node:</b>");
            path.setStyleName("text");
            this.addMember((Canvas)path);
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Label();
                this.segments[i].setAutoWidth();
                this.segments[i].setStyleName("segment");
                this.segments[i].addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Label label = (Label)event.getSource();
                        Contents.this.getAndDisplayNode(label.getDataPath(), true);
                    }
                });
                this.separators[i] = new Label();
                this.separators[i].setContents(Contents.ROOT_PATH);
                this.separators[i].setVisible(false);
                this.separators[i].setAutoWidth();
                this.separators[i].setStyleName("segment-separator");
                this.separators[i].setMargin(Integer.valueOf(3));
                this.addMember((Canvas)this.segments[i]);
                this.addMember((Canvas)this.separators[i]);
            }
        }

        public void display(String url) {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i].setContents("");
                this.separators[i].setVisible(false);
            }
            String[] tokens = url.split(Contents.ROOT_PATH);
            if (tokens.length == 0) {
                tokens = new String[]{Contents.ROOT_PATH};
            }
            for (int i = 0; i < tokens.length; ++i) {
                this.segments[i].setContents(tokens[i]);
                String path = "";
                for (int j = 0; j <= i; ++j) {
                    path = path + Contents.ROOT_PATH + this.segments[j].getContents();
                }
                this.segments[i].setTooltip(path);
                this.segments[i].setDataPath(path);
                this.segments[i].draw();
                if (i >= tokens.length - 1) continue;
                this.separators[i].setVisible(true);
            }
        }
    }
}

