/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.layout.HLayout;
import java.util.Collection;
import org.modeshape.web.client.grid.BooleanField;
import org.modeshape.web.client.grid.Grid;
import org.modeshape.web.shared.JcrNodeType;

public class NodeTypes
extends Grid<TypeRecord, JcrNodeType> {
    private static final int RECORDS_PER_PAGE = 500;

    public NodeTypes() {
        super("Node types");
    }

    public void show(Collection<JcrNodeType> types) {
        this.setValues(types);
    }

    protected TypeRecord[] records() {
        TypeRecord[] records = new TypeRecord[500];
        for (int i = 0; i < records.length; ++i) {
            records[i] = new TypeRecord();
        }
        return records;
    }

    @Override
    protected HLayout tableHeader() {
        HLayout layout = new HLayout();
        layout.setHeight(30);
        layout.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Name</b>");
        name.setWidth(450);
        Label type = new Label("<b>Primary</b>");
        type.setWidth(100);
        Label visibility = new Label("<b>Mixin</b>");
        visibility.setWidth(100);
        Label mvalue = new Label("<b>Abstract</b>");
        mvalue.setWidth(100);
        layout.addMember((Canvas)name);
        layout.addMember((Canvas)type);
        layout.addMember((Canvas)visibility);
        layout.addMember((Canvas)mvalue);
        return layout;
    }

    @Override
    protected HLayout toolBar() {
        return null;
    }

    @Override
    protected void updateRecord(int pos, TypeRecord record, JcrNodeType value) {
        record.setValue(value);
    }

    public class TypeRecord
    extends HLayout {
        private Label name = new Label();
        private BooleanField isPrimary = new BooleanField();
        private BooleanField isMixin = new BooleanField();
        private BooleanField isAbstract = new BooleanField();

        public TypeRecord() {
            this.setStyleName("grid");
            this.setHeight(30);
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setIcon("icons/sprocket.png");
            this.name.setStyleName("text");
            this.name.setWidth(450);
            this.isPrimary.setWidth(100);
            this.isMixin.setWidth(100);
            this.isAbstract.setWidth(100);
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.isPrimary);
            this.addMember((Canvas)this.isMixin);
            this.addMember((Canvas)this.isAbstract);
        }

        private void setValue(JcrNodeType nodeType) {
            this.name.setContents(nodeType.getName());
            this.isPrimary.setValue(nodeType.isPrimary());
            this.isAbstract.setValue(nodeType.isAbstract());
            this.isMixin.setValue(nodeType.isMixin());
        }
    }
}

