/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;

public abstract class TabGrid<R extends HLayout, V>
extends VLayout {
    private R[] records;
    private final VLayout viewPort = new VLayout();

    public TabGrid(String caption) {
        this.init(caption);
    }

    private void init(String caption) {
        HLayout header;
        this.records = this.records();
        this.setStyleName("grid-bg");
        HLayout toolBar = this.toolBar();
        if (toolBar != null) {
            this.addMember((Canvas)toolBar);
        }
        if ((header = this.tableHeader()) != null) {
            this.addMember((Canvas)header);
        }
        this.setAutoHeight();
        HLayout bottomPanel = new HLayout();
        bottomPanel.setHeight(30);
        bottomPanel.setBackgroundColor("#e6f1f6");
        this.viewPort.setAutoHeight();
        this.addMember((Canvas)this.viewPort);
    }

    protected abstract R[] records();

    protected abstract HLayout tableHeader();

    protected abstract HLayout toolBar();

    protected void setValues(Collection<V> values) {
        int i;
        try {
            for (i = 0; i < this.records.length; ++i) {
                this.records[i].setVisible(false);
                this.viewPort.removeMember(this.records[i]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (values.isEmpty()) {
            this.viewPort.addMember(this.records[0]);
            this.updateRecord(-1, this.records[0], null);
            this.records[0].show();
            return;
        }
        i = 0;
        try {
            for (V value : values) {
                this.viewPort.addMember(this.records[i]);
                this.updateRecord(i, this.records[i], value);
                this.records[i].show();
                ++i;
            }
        }
        catch (Exception e) {
            SC.say((String)Integer.toString(i));
        }
    }

    protected abstract void updateRecord(int var1, R var2, V var3);

    protected class Strut
    extends HLayout {
        public Strut(int size) {
            this.setWidth(size);
        }
    }
}

