/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.web.server.Connector;

public class BinaryContentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String repository = request.getParameter("repository");
        String workspace = request.getParameter("workspace");
        String path = request.getParameter("path");
        String property = request.getParameter("property");
        Connector connector = (Connector)request.getSession().getAttribute("connector");
        try {
            int b;
            Property p;
            Session session = connector.find(repository).session(workspace);
            Node node = session.getNode(path);
            try {
                p = node.getProperty(property);
            }
            catch (PathNotFoundException e) {
                response.setContentType("text/html");
                PrintWriter writer = response.getWriter();
                writer.write("<html>");
                writer.write("<p>Content not found or recently removed</p>");
                writer.write("</html>");
                return;
            }
            Binary binary = p.getBinary();
            InputStream in = binary.getStream();
            String contentType = node.getProperty("jcr:mimeType").getString();
            response.setContentType(contentType);
            while ((b = in.read()) != -1) {
                response.getOutputStream().write(b);
            }
            binary.dispose();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

