/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.AddPrincipalDialog;
import org.modeshape.web.client.Contents;
import org.modeshape.web.client.grid.BooleanField;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.Policy;

public class AccessList
extends TabGrid<AclRecord, Policy> {
    private final AclRecord[] records = new AclRecord[]{new AclRecord(JcrPermission.ALL), new AclRecord(JcrPermission.LIFECYCLE_MANAGEMENT), new AclRecord(JcrPermission.LOCK_MANAGEMENT), new AclRecord(JcrPermission.MODIFY_ACCESS_CONTROL), new AclRecord(JcrPermission.MODIFY_PROPERTIES), new AclRecord(JcrPermission.NODE_TYPE_MANAGEMENT), new AclRecord(JcrPermission.READ), new AclRecord(JcrPermission.READ_ACCESS_CONTROL), new AclRecord(JcrPermission.REMOVE_CHILD_NODES), new AclRecord(JcrPermission.RETENTION_MANAGEMENT), new AclRecord(JcrPermission.VERSION_MANAGEMENT), new AclRecord(JcrPermission.WRITE)};
    private JcrNode node;
    protected final Contents contents;
    private ComboBoxItem principal;
    protected final AddPrincipalDialog addAccessListDialog;

    public AccessList(Contents contents) {
        super("Access list");
        this.contents = contents;
        this.addAccessListDialog = new AddPrincipalDialog(contents);
    }

    public void show(JcrNode node) {
    }

    protected AclRecord[] records() {
        return this.records;
    }

    @Override
    protected HLayout tableHeader() {
        HLayout layout = new HLayout();
        layout.setHeight(30);
        layout.setWidth100();
        layout.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Permission</b>");
        name.setWidth(450);
        Label type = new Label("<b>Status</b>");
        type.setWidth(150);
        layout.addMember((Canvas)name);
        layout.addMember((Canvas)type);
        return layout;
    }

    @Override
    protected HLayout toolBar() {
        HLayout layout = new HLayout();
        layout.setBackgroundColor("#ffffff");
        layout.setAlign(Alignment.LEFT);
        layout.setDefaultLayoutAlign(Alignment.LEFT);
        layout.setLayoutAlign(Alignment.LEFT);
        layout.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        layout.setLayoutAlign(VerticalAlignment.CENTER);
        layout.setHeight(30);
        layout.setWidth100();
        this.principal = new ComboBoxItem("Principal");
        DynamicForm form = new DynamicForm();
        form.setItems(new FormItem[]{this.principal});
        layout.addMember((Canvas)form);
        HLayout panel = new HLayout();
        panel.setAlign(Alignment.RIGHT);
        panel.setWidth100();
        panel.setDefaultLayoutAlign(Alignment.RIGHT);
        panel.setLayoutAlign(Alignment.RIGHT);
        panel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        Label hint = new Label();
        hint.setWidth(200);
        hint.setAlign(Alignment.RIGHT);
        hint.setLayoutAlign(VerticalAlignment.BOTTOM);
        hint.setContents("Click button to switch view");
        Button addButton = new Button();
        addButton.setTitle("Add access list");
        addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AccessList.this.addAccessListDialog.showModal();
            }
        });
        Button remButton = new Button();
        remButton.setTitle("Delete access list");
        remButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String name = AccessList.this.principal.getValueAsString();
                SC.ask((String)("Remove acl for " + name + "?"), (BooleanCallback)new BooleanCallback(){

                    public void execute(Boolean value) {
                        if (value.booleanValue()) {
                            AccessList.this.contents.removeAccessList(name);
                        }
                    }
                });
            }
        });
        Button applyButton = new Button();
        applyButton.setTitle("Apply access list");
        applyButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SC.ask((String)"Apply ACL changes?", (BooleanCallback)new BooleanCallback(){

                    public void execute(Boolean value) {
                        if (value.booleanValue()) {
                            AccessList.this.contents.applyAccessList();
                        }
                    }
                });
            }
        });
        HLayout strut = new HLayout();
        strut.setWidth(5);
        layout.addMember((Canvas)panel);
        panel.addMember((Canvas)new TabGrid.Strut(this, 10));
        panel.addMember((Canvas)addButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)remButton);
        panel.addMember((Canvas)strut);
        panel.addMember((Canvas)applyButton);
        return layout;
    }

    @Override
    protected void updateRecord(int pos, AclRecord record, Policy value) {
        record.test(value);
    }

    public class AclRecord
    extends HLayout {
        private final JcrPermission permission;
        private Label name = new Label();
        private Label description = new Label();
        private BooleanField value = new BooleanField();

        public AclRecord(final JcrPermission permission) {
            this.permission = permission;
            this.setStyleName("grid");
            this.setHeight(30);
            this.setWidth100();
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setContents(permission.getDisplayName());
            this.name.setIcon("icons/shield.png");
            this.name.setStyleName("text");
            this.name.setWidth(350);
            this.value.setWidth(50);
            this.value.setStyleName("text");
            this.value.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AccessList.this.node.getAcl().modify(AccessList.this.principal.getValueAsString(), permission, !AclRecord.this.value.getValue());
                }
            });
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.description);
            this.addMember((Canvas)this.value);
        }

        private boolean test(Policy policy) {
            boolean val = policy.hasPermission(this.permission);
            this.value.setValue(val);
            return val;
        }
    }
}

