/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.web.client.RemoteException;
import org.modeshape.web.server.Connector;
import org.modeshape.web.server.LRepository;
import org.modeshape.web.server.impl.LRepositoryImpl;
import org.modeshape.web.server.impl.RepositoryList;
import org.modeshape.web.shared.RepositoryName;

public class ConnectorImpl
implements Connector {
    private static final String JNDI_PREFIX_PARAM = "jndi-prefix";
    private static final String DEFAULT_JNDI_PREFIX = "jcr";
    private static final long serialVersionUID = 1L;
    private transient HashMap<String, LRepository> repositories = new HashMap();
    private transient Collection<RepositoryName> repositoryNames;
    private transient Credentials credentials;
    private transient String userName;
    private transient ModeShapeEngine engine;
    private RepositoryList repoList;
    private static final Logger logger = Logger.getLogger(ConnectorImpl.class);

    @Override
    public void start(ServletContext context) throws RemoteException {
        String jndiPrefix = context.getInitParameter(JNDI_PREFIX_PARAM);
        if (jndiPrefix == null) {
            jndiPrefix = DEFAULT_JNDI_PREFIX;
        }
        try {
            InitialContext ic = new InitialContext();
            this.engine = (ModeShapeEngine)ic.lookup(jndiPrefix);
            this.repoList = new RepositoryList(this.engine);
            this.repositoryNames = this.repoList.getRepositories(null);
        }
        catch (NamingException | RemoteException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public void login(String username, String password) throws RemoteException {
        this.userName = username;
        if (username == null) {
            this.credentials = null;
        }
        this.credentials = password == null ? new SimpleCredentials(username, null) : new SimpleCredentials(username, password.toCharArray());
        try {
            this.repositoryNames = this.repoList.getRepositories(this.credentials);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public void logout() {
        this.credentials = null;
        this.userName = null;
        try {
            this.repositoryNames = this.repoList.getRepositories(null);
        }
        catch (RemoteException e) {
            this.repositoryNames.clear();
        }
    }

    @Override
    public String userName() {
        return this.userName;
    }

    @Override
    public Collection<RepositoryName> getRepositories() {
        return this.repositoryNames;
    }

    @Override
    public LRepository find(String name) throws RemoteException {
        if (!this.repositories.containsKey(name)) {
            try {
                logger.debug("Starting repository: " + name, new Object[0]);
                this.repositories.put(name, new LRepositoryImpl(this.engine.getRepository(name), this.credentials));
            }
            catch (Exception e) {
                logger.debug("Could not start repository " + name, new Object[]{e});
                throw new RemoteException(e.getMessage());
            }
        }
        return this.repositories.get(name);
    }

    @Override
    public Collection<RepositoryName> search(String name) {
        ArrayList<RepositoryName> list = new ArrayList<RepositoryName>();
        for (RepositoryName n : this.repositoryNames) {
            if (!n.getName().contains(name) && !n.getDescriptor().contains(name)) continue;
            list.add(n);
        }
        return list;
    }
}

