/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.admin;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.admin.AdminView;
import org.modeshape.web.client.admin.BackupDialog;
import org.modeshape.web.shared.BackupParams;

public class BackupControl
extends VLayout {
    private final BackupDialog backupDialog = new BackupDialog(this);
    private final AdminView adminView;

    public BackupControl(AdminView adminView) {
        this.adminView = adminView;
        this.setStyleName("admin-control");
        Label label = new Label("Backup");
        label.setIcon("icons/data.png");
        label.setStyleName("button-label");
        label.setHeight(25);
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BackupControl.this.backupDialog.showModal();
            }
        });
        Canvas text = new Canvas();
        text.setAutoHeight();
        text.setContents("Create backups of an entire repository (even when the repository is in use)This works regardless of where the repository content is persisted.");
        this.addMember((Canvas)label);
        this.addMember(text);
    }

    protected void backup(String name, BackupParams params) {
        this.adminView.jcrService().backup(this.adminView.repository(), name, params, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }
}

