/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.contents;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.contents.RenameNodeDialog;
import org.modeshape.web.client.grid.Grid;
import org.modeshape.web.shared.Columns;
import org.modeshape.web.shared.JcrNode;

public class ChildrenEditor
extends Grid<NodeRecord, JcrNode> {
    private JcrNode node;
    private final Contents contents;
    private final RenameNodeDialog renameNodeDialog;
    private Label hint;

    public ChildrenEditor(Contents contents) {
        super("Child nodes");
        this.contents = contents;
        this.renameNodeDialog = new RenameNodeDialog(contents);
    }

    public void show(JcrNode node) {
        this.node = node;
        this.setValues(node.children());
        String hintText = node.hasBinaryContent() ? "This node has binary content attached. See bellow" : "This node has no binary content attached";
        this.hint.setContents(hintText);
    }

    @Override
    protected HLayout tableHeader() {
        HLayout header = new HLayout();
        header.setHeight(30);
        header.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Name</b>");
        name.setWidth(150);
        name.setIcon("icons/view_tree_modernist.png");
        Label type = new Label("<b>Primary Type</b>");
        type.setWidth(150);
        type.setIcon("icons/documents.png");
        Label path = new Label("<b>Path</b>");
        path.setWidth100();
        path.setIcon("icons/view_table.png");
        header.addMember((Canvas)name);
        header.addMember((Canvas)type);
        header.addMember((Canvas)path);
        return header;
    }

    @Override
    protected HLayout toolBar() {
        this.hint = new Label();
        this.hint.setWidth100();
        Label hint2 = new Label();
        hint2.setContents("Enable/Disbale properties");
        hint2.setWidth(250);
        hint2.setAlign(Alignment.RIGHT);
        Label detailsButton = new Label();
        detailsButton.setTooltip("Show details");
        detailsButton.setStyleName("button-label");
        detailsButton.setWidth(16);
        detailsButton.setIcon("icons/view_table.png");
        detailsButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChildrenEditor.this.contents.toggleDetails();
            }
        });
        Columns col = new Columns(1, 5);
        col.setBackgroundColor("#ffffff");
        col.setHeight(30);
        col.addMember((Canvas)this.hint);
        col.addMember((Canvas)hint2);
        col.addMember((Canvas)detailsButton);
        return col;
    }

    protected NodeRecord[] records() {
        NodeRecord[] recs = new NodeRecord[100];
        for (int i = 0; i < recs.length; ++i) {
            recs[i] = new NodeRecord();
        }
        return recs;
    }

    @Override
    protected void updateRecord(int pos, NodeRecord record, JcrNode value) {
        if (pos <= 0) {
            record.setNodeAsParent(this.node);
            record.setVisible(!this.node.getPath().equals("/"));
        } else {
            record.setNode(value);
        }
    }

    private class Buttons
    extends HLayout {
        private Label editButton = new Label();
        private Label remButton = new Label();
        private JcrNode node;

        public Buttons() {
            this.setWidth(36);
            this.setDefaultLayoutAlign(Alignment.RIGHT);
            this.setLayoutAlign(Alignment.RIGHT);
            this.setAlign(Alignment.RIGHT);
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.editButton.setWidth(16);
            this.editButton.setHeight(16);
            this.editButton.setIcon("icons/pencil.png");
            this.editButton.setStyleName("button-label");
            this.editButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ChildrenEditor.this.renameNodeDialog.showModal(Buttons.this.node);
                }
            });
            this.remButton.setWidth(16);
            this.remButton.setHeight(16);
            this.remButton.setIcon("icons/cross.png");
            this.remButton.setStyleName("button-label");
            this.remButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SC.ask((String)"Remove node", (String)"Do you want to remove node?", (BooleanCallback)new BooleanCallback(){

                        public void execute(Boolean confirmed) {
                            if (confirmed.booleanValue()) {
                                ChildrenEditor.this.contents.removeNode(Buttons.this.node);
                            }
                        }
                    });
                }
            });
            this.addMember((Canvas)this.editButton);
            this.addMember((Canvas)this.remButton);
        }

        protected void setNode(JcrNode node) {
            this.node = node;
        }
    }

    public class NodeRecord
    extends HLayout {
        private Label name = new Label();
        private Label path = new Label();
        private Label primaryType = new Label();
        private Buttons buttons = new Buttons();
        private JcrNode node;

        public NodeRecord() {
            this.setStyleName("grid");
            this.setHeight(30);
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setStyleName("node-name");
            this.name.setIcon("icons/folder.png");
            this.name.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ChildrenEditor.this.contents.getAndDisplayNode(NodeRecord.this.path(), true);
                }
            });
            this.name.setWidth(150);
            this.primaryType.setWidth(150);
            this.primaryType.setStyleName("text");
            this.path.setWidth100();
            this.path.setStyleName("text");
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.primaryType);
            this.addMember((Canvas)this.path);
            this.addMember((Canvas)this.buttons);
        }

        private String path() {
            return this.node == null ? "/" : this.path.getContents();
        }

        private void setNode(JcrNode node) {
            this.node = node;
            this.name.setContents(node.getName());
            this.path.setContents(node.getPath());
            this.path.setVisible(true);
            this.buttons.setVisible(true);
            this.buttons.setNode(node);
            this.primaryType.setContents(node.getPrimaryType());
        }

        private void setNodeAsParent(JcrNode node) {
            this.node = node;
            this.name.setContents("<b>../</b>");
            this.path.setContents(this.parent(node.getPath()));
            this.path.setVisible(false);
            this.buttons.setVisible(false);
            this.buttons.setNode(node);
            this.primaryType.setContents("");
        }

        private String parent(String path) {
            if (path == null) {
                return "/";
            }
            if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
                return "/";
            }
            return path;
        }
    }
}

