/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.peditor;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.CloseClickHandler;
import com.smartgwt.client.widgets.events.CloseClientEvent;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.SpacerItem;
import com.smartgwt.client.widgets.form.fields.SubmitItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VStack;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.peditor.BinaryValueEditor;
import org.modeshape.web.client.peditor.BooleanValueEditor;
import org.modeshape.web.client.peditor.DateValueEditor;
import org.modeshape.web.client.peditor.DefaultValueEditor;
import org.modeshape.web.client.peditor.MixinValueEditor;
import org.modeshape.web.client.peditor.ValueEditor;

public abstract class BaseEditor {
    private final Window window = new Window();
    protected final DynamicForm form = new DynamicForm();
    private final SubmitItem confirmButton = new SubmitItem("OK");
    private final SubmitItem cancelButton = new SubmitItem("Cancel");
    protected final VStack vStack = new VStack();
    private HLayout panel = new HLayout();

    public BaseEditor(String title, int width, int height) {
        this.form.setNumCols(2);
        this.form.setPadding(Integer.valueOf(25));
        this.panel.setVisible(false);
        this.vStack.setTop(10);
        this.vStack.addMember((Canvas)this.panel);
        this.vStack.addMember((Canvas)this.form);
        this.window.addChild((Canvas)this.vStack);
        this.window.setTitle(title);
        this.window.setCanDragReposition(Boolean.valueOf(true));
        this.window.setCanDragResize(Boolean.valueOf(false));
        this.window.setShowMinimizeButton(Boolean.valueOf(false));
        this.window.setShowCloseButton(Boolean.valueOf(true));
        this.window.setWidth(width);
        this.window.setHeight(height);
        this.window.setAutoCenter(Boolean.valueOf(true));
        this.window.addCloseClickHandler(new CloseClickHandler(){

            public void onCloseClick(CloseClientEvent event) {
                BaseEditor.this.hide();
            }
        });
        this.confirmButton.setTitle("OK");
        this.confirmButton.setWidth(100);
        this.confirmButton.setStartRow(Boolean.valueOf(true));
        this.confirmButton.setEndRow(Boolean.valueOf(false));
        this.confirmButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BaseEditor.this.onConfirm(event);
                BaseEditor.this.hide();
            }
        });
        this.cancelButton.setTitle("Cancel");
        this.cancelButton.setWidth(100);
        this.cancelButton.setStartRow(Boolean.valueOf(false));
        this.cancelButton.setEndRow(Boolean.valueOf(true));
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BaseEditor.this.hide();
            }
        });
    }

    public BaseEditor(String title) {
        this.panel.setWidth100();
        this.panel.setHeight100();
        this.vStack.setTop(10);
        this.window.addChild((Canvas)this.vStack);
        this.window.setTitle(title);
        this.window.setCanDragReposition(Boolean.valueOf(true));
        this.window.setCanDragResize(Boolean.valueOf(false));
        this.window.setShowMinimizeButton(Boolean.valueOf(false));
        this.window.setShowCloseButton(Boolean.valueOf(true));
        this.window.setAutoCenter(Boolean.valueOf(true));
        this.window.addCloseClickHandler(new CloseClickHandler(){

            public void onCloseClick(CloseClientEvent event) {
                BaseEditor.this.hide();
            }
        });
        this.vStack.addMember((Canvas)this.panel);
    }

    public void setWidth(int width) {
        this.window.setWidth(width);
    }

    public void setHeight(int height) {
        this.window.setHeight(height);
    }

    public void setTop(int top) {
        this.vStack.setTop(top);
    }

    public void addMember(Canvas canvas) {
        this.vStack.addMember(canvas);
    }

    public static ValueEditor<String> getValueEditor(String pname, String type, Contents contents) {
        if (pname.equals("jcr:mixinTypes")) {
            return new MixinValueEditor(contents);
        }
        if (type.equals("Boolean")) {
            return new BooleanValueEditor(contents);
        }
        if (type.equals("Binary")) {
            return new BinaryValueEditor();
        }
        if (type.equals("Date")) {
            return new DateValueEditor(contents);
        }
        return new DefaultValueEditor(contents);
    }

    public void hide() {
        this.window.hide();
    }

    public abstract void onConfirm(ClickEvent var1);

    public void setControls(FormItem ... items) {
        FormItem[] controls = new FormItem[items.length + 3];
        int i = 0;
        for (FormItem item : items) {
            controls[i++] = item;
        }
        controls[i++] = new SpacerItem();
        controls[i++] = this.confirmButton;
        controls[i++] = this.cancelButton;
        this.form.setItems(controls);
    }

    protected void showModal() {
        this.window.show();
    }
}

