/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.peditor;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.MultipleAppearance;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.ArrayList;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.peditor.BaseEditor;
import org.modeshape.web.client.peditor.ValueEditor;
import org.modeshape.web.shared.Columns;
import org.modeshape.web.shared.JcrNode;

public class MixinValueEditor
extends BaseEditor
implements ValueEditor<String> {
    private static final String TITLE = "Modify property value";
    private static final int WIDTH = 430;
    private static final int HEIGHT = 350;
    private final SelectItem mixTypes = new SelectItem("");
    private final SelectItem selectedTypes = new SelectItem("");
    private final Contents contents;
    private JcrNode node;
    private String name;
    private String[] allTypes;
    private String[] nodeTypes;
    private String[] originalNodeTypes;

    public MixinValueEditor(Contents contents) {
        super(TITLE);
        this.contents = contents;
        this.setWidth(430);
        this.setHeight(350);
        Columns h1 = new Columns(5, 5);
        h1.setHeight(15);
        Label l1 = new Label();
        l1.setWidth(150);
        l1.setContents("Mixin Types");
        Label l2 = new Label();
        l2.setWidth(100);
        l2.setContents("");
        Label l3 = new Label();
        l3.setWidth(150);
        l3.setContents("Node's types");
        h1.addMember((Canvas)l1);
        h1.addMember((Canvas)l2);
        h1.addMember((Canvas)l3);
        this.addMember((Canvas)h1);
        Columns layout = new Columns(5, 5);
        layout.setWidth100();
        this.mixTypes.setMultiple(Boolean.valueOf(true));
        this.mixTypes.setMultipleAppearance(MultipleAppearance.GRID);
        this.mixTypes.setWidth(150);
        this.mixTypes.setHeight(200);
        this.selectedTypes.setMultiple(Boolean.valueOf(true));
        this.selectedTypes.setMultipleAppearance(MultipleAppearance.GRID);
        this.selectedTypes.setWidth(150);
        this.selectedTypes.setHeight(200);
        DynamicForm f1 = new DynamicForm();
        f1.setItems(new FormItem[]{this.mixTypes});
        f1.setWidth(150);
        f1.setHeight(200);
        DynamicForm f2 = new DynamicForm();
        f2.setItems(new FormItem[]{this.selectedTypes});
        f2.setWidth(150);
        f2.setHeight(200);
        VLayout buttons = new VLayout();
        buttons.setLayoutAlign(Alignment.CENTER);
        buttons.setDefaultLayoutAlign(Alignment.CENTER);
        buttons.setAlign(Alignment.CENTER);
        buttons.setLayoutAlign(VerticalAlignment.CENTER);
        buttons.setWidth(50);
        layout.addMember((Canvas)f1);
        layout.addMember((Canvas)buttons);
        layout.addMember((Canvas)f2);
        Button b1 = new Button(">>");
        b1.setWidth(30);
        b1.addClickHandler(new ClickHandler(){

            public void onClick(com.smartgwt.client.widgets.events.ClickEvent event) {
                MixinValueEditor.access$002(MixinValueEditor.this, MixinValueEditor.this.remove(MixinValueEditor.this.allTypes, MixinValueEditor.this.mixTypes.getValueAsString()));
                MixinValueEditor.access$302(MixinValueEditor.this, MixinValueEditor.this.add(MixinValueEditor.this.nodeTypes, MixinValueEditor.this.mixTypes.getValueAsString()));
                MixinValueEditor.this.updateLists();
            }
        });
        Button b2 = new Button("<<");
        b2.setWidth(30);
        b2.addClickHandler(new ClickHandler(){

            public void onClick(com.smartgwt.client.widgets.events.ClickEvent event) {
                MixinValueEditor.access$302(MixinValueEditor.this, MixinValueEditor.this.remove(MixinValueEditor.this.nodeTypes, MixinValueEditor.this.selectedTypes.getValueAsString()));
                MixinValueEditor.access$002(MixinValueEditor.this, MixinValueEditor.this.add(MixinValueEditor.this.allTypes, MixinValueEditor.this.selectedTypes.getValueAsString()));
                MixinValueEditor.this.updateLists();
            }
        });
        buttons.addMember((Canvas)b1);
        buttons.addMember((Canvas)b2);
        this.addMember((Canvas)layout);
        Columns h3 = new Columns(3, 5);
        h3.setHeight(50);
        Button okButton = new Button("OK");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(com.smartgwt.client.widgets.events.ClickEvent event) {
                MixinValueEditor.this.onConfirm(null);
                MixinValueEditor.this.hide();
            }
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(com.smartgwt.client.widgets.events.ClickEvent event) {
                MixinValueEditor.this.hide();
            }
        });
        h3.addMember((Canvas)okButton);
        h3.addMember((Canvas)cancelButton);
        this.addMember((Canvas)h3);
    }

    @Override
    public void showModal() {
        this.contents.jcrService().getMixinTypes(this.contents.repository(), this.contents.workspace(), false, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                MixinValueEditor.access$002(MixinValueEditor.this, result);
                MixinValueEditor.this.updateLists();
                MixinValueEditor.super.showModal();
            }
        });
    }

    private void updateLists() {
        this.mixTypes.setValueMap(this.diff(this.allTypes, this.nodeTypes));
        this.selectedTypes.setValueMap(this.diff(this.nodeTypes, this.allTypes));
    }

    private String[] parseValues(String value) {
        if (value.equalsIgnoreCase("N/A")) {
            return new String[0];
        }
        return value.split(",");
    }

    @Override
    public void setValue(JcrNode node, String name, String value) {
        this.node = node;
        this.name = name;
        this.nodeTypes = this.parseValues(value);
        this.originalNodeTypes = this.parseValues(value);
        this.showModal();
    }

    private String[] remove(String[] values, String value) {
        String[] res = new String[values.length - 1];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equalsIgnoreCase(value)) continue;
            res[j++] = values[i];
        }
        return res;
    }

    private String[] add(String[] values, String value) {
        String[] res = new String[values.length + 1];
        for (int i = 0; i < values.length; ++i) {
            res[i] = values[i];
        }
        res[values.length] = value;
        return res;
    }

    private String[] diff(String[] a, String[] b) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            boolean found = false;
            for (int j = 0; j < b.length; ++j) {
                if (!a[i].equalsIgnoreCase(b[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(a[i]);
        }
        String[] map = new String[list.size()];
        list.toArray(map);
        return map;
    }

    @Override
    public void onConfirm(ClickEvent event) {
        int j;
        int i;
        for (i = 0; i < this.nodeTypes.length; ++i) {
            boolean isNew = true;
            for (j = 0; j < this.originalNodeTypes.length; ++j) {
                if (!this.nodeTypes[i].equalsIgnoreCase(this.originalNodeTypes[j])) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            this.contents.addMixin(this.nodeTypes[i]);
        }
        for (i = 0; i < this.originalNodeTypes.length; ++i) {
            boolean isRemoved = false;
            for (j = 0; j < this.nodeTypes.length; ++j) {
                if (!this.originalNodeTypes[i].equalsIgnoreCase(this.nodeTypes[j])) continue;
                isRemoved = false;
                break;
            }
            if (!isRemoved) continue;
            this.contents.removeMixin(this.nodeTypes[i]);
        }
    }

    static /* synthetic */ String[] access$002(MixinValueEditor x0, String[] x1) {
        x0.allTypes = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(MixinValueEditor x0, String[] x1) {
        x0.nodeTypes = x1;
        return x1;
    }
}

