/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.admin;

import com.smartgwt.client.widgets.form.fields.CheckboxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.StaticTextItem;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import org.modeshape.web.client.admin.BackupControl;
import org.modeshape.web.shared.BackupParams;
import org.modeshape.web.shared.ModalDialog;

public class BackupDialog
extends ModalDialog {
    private final TextItem nameField = new TextItem("Backup name");
    private final CheckboxItem incBinariesField = new CheckboxItem("Include binaries");
    private final CheckboxItem compressField = new CheckboxItem("Compress files");
    private final TextItem docsPerFileField = new TextItem("Documents per file");
    private final BackupControl control;

    public BackupDialog(BackupControl control) {
        super("Backup", 400, 200);
        this.control = control;
        StaticTextItem description = new StaticTextItem("");
        description.setValue("Specify backup name");
        this.setDefaults();
        this.setControls(new FormItem[]{description, this.nameField, this.incBinariesField, this.compressField, this.docsPerFileField});
    }

    private void setDefaults() {
        this.incBinariesField.setValue(true);
        this.compressField.setValue(true);
        this.docsPerFileField.setValue("10000");
    }

    @Override
    public void onConfirm(ClickEvent event) {
        BackupParams params = new BackupParams();
        params.setIncludeBinaries(this.incBinariesField.getValueAsBoolean());
        params.setCompress(this.compressField.getValueAsBoolean());
        params.setDocumentsPerFile(Long.valueOf(this.docsPerFileField.getValueAsString()));
        this.control.backup(this.nameField.getValueAsString(), params);
    }
}

