/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.Footer;
import org.modeshape.web.client.Header;
import org.modeshape.web.client.HtmlHistory;
import org.modeshape.web.client.JcrService;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.JcrURL;
import org.modeshape.web.client.LoadingIcon;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.repo.RepositoriesList;
import org.modeshape.web.client.repo.RepositoryHeader;
import org.modeshape.web.shared.BaseCallback;
import org.modeshape.web.shared.RepositoryName;

public class Console
implements EntryPoint,
ValueChangeHandler<String> {
    private static final String LAYOUT_WIDTH = "85%";
    private final JcrServiceAsync jcrService = (JcrServiceAsync)GWT.create(JcrService.class);
    private final VLayout mainForm = new VLayout();
    private final JcrURL jcrURL = new JcrURL();
    private final HtmlHistory htmlHistory = new HtmlHistory();
    private final VLayout viewPort = new VLayout();
    private final Header header = new Header(this);
    private final Footer footer = new Footer();
    private final RepositoriesList repositoriesList = new RepositoriesList(this, this.jcrService);
    private final RepositoryHeader repositoryHeader = new RepositoryHeader(this);
    private final Contents contents = new Contents(this);
    private final LoadingIcon loadingIcon = new LoadingIcon();

    public JcrServiceAsync jcrService() {
        return this.jcrService;
    }

    public void onModuleLoad() {
        this.jcrService.getRequestedURI((AsyncCallback<String>)new BaseCallback<String>(){

            public void onSuccess(String result) {
                Console.this.jcrURL.parse(result);
                Console.this.getCredentials();
            }
        });
    }

    private void getCredentials() {
        this.jcrService.getUserName((AsyncCallback<String>)new BaseCallback<String>(){

            public void onSuccess(String name) {
                Console.this.showMainForm(name);
            }
        });
    }

    public void loadNodeSpecifiedByURL() {
        this.repositoriesList.select(this.jcrURL.getRepository(), this.jcrURL.getWorkspace(), this.jcrURL.getPath(), true);
    }

    protected void changeUserName(String userName) {
        this.header.setUserName(userName);
    }

    public String repository() {
        return this.repositoryHeader.repository();
    }

    public void showMainForm(String userName) {
        this.align();
        this.changeUserName(userName);
        this.mainForm.addMember((Canvas)this.header);
        this.mainForm.addMember((Canvas)this.repositoryHeader);
        this.mainForm.addMember((Canvas)this.viewPort);
        this.mainForm.addMember((Canvas)this.strut(30));
        this.mainForm.addMember((Canvas)this.footer);
        this.setLayoutWidth(LAYOUT_WIDTH);
        this.loadData();
        this.htmlHistory.addValueChangeHandler(this);
        this.mainForm.draw();
    }

    private void align() {
        this.mainForm.setLayoutMargin(Integer.valueOf(5));
        this.mainForm.setWidth100();
        this.mainForm.setHeight100();
        this.mainForm.setBackgroundColor("#FFFFFF");
        this.mainForm.setAlign(Alignment.CENTER);
        this.mainForm.setLayoutAlign(Alignment.CENTER);
        this.mainForm.setDefaultLayoutAlign(Alignment.CENTER);
        this.viewPort.setWidth(LAYOUT_WIDTH);
        this.viewPort.setLayoutAlign(Alignment.CENTER);
        this.viewPort.setAlign(Alignment.CENTER);
        this.viewPort.setDefaultLayoutAlign(Alignment.CENTER);
    }

    private boolean isInitialUrlPointsNode() {
        return this.jcrURL.getRepository() != null && this.jcrURL.getRepository().length() > 0;
    }

    private void loadData() {
        if (this.isInitialUrlPointsNode()) {
            this.loadNodeSpecifiedByURL();
        } else {
            this.loadRepositoriesList();
        }
    }

    public void loadRepositoriesList() {
        this.repositoriesList.load();
    }

    private void setLayoutWidth(String value) {
        this.repositoryHeader.setLayoutWidth(value);
        this.viewPort.setWidth(value);
    }

    public Contents contents() {
        return this.contents;
    }

    public void showLoadingIcon() {
        this.loadingIcon.show(this.mainForm.getWidth() / 2, this.mainForm.getHeight() / 2);
    }

    public void hideLoadingIcon() {
        this.loadingIcon.hide();
    }

    public void displayRepository(String name) {
        this.repositoryHeader.show(name);
    }

    public void hideRepository() {
        this.repositoryHeader.hide();
    }

    public void changeRepositoryInURL(String name, boolean changeHistory) {
        this.jcrURL.setRepository(name);
        if (changeHistory) {
            this.htmlHistory.newItem(this.jcrURL.toString(), false);
        }
    }

    public void changeWorkspaceInURL(String name, boolean changeHistory) {
        this.jcrURL.setWorkspace(name);
        if (changeHistory) {
            this.htmlHistory.newItem(this.jcrURL.toString(), false);
        }
    }

    public void changePathInURL(String path, boolean changeHistory) {
        this.jcrURL.setPath(path);
        if (changeHistory) {
            this.htmlHistory.newItem(this.jcrURL.toString(), false);
        }
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.jcrURL.parse2((String)event.getValue());
        this.repositoriesList.select(this.jcrURL.getRepository(), this.jcrURL.getWorkspace(), this.jcrURL.getPath(), false);
    }

    public void showRepositories(Collection<RepositoryName> names) {
        this.repositoriesList.show(names);
        this.display((Canvas)this.repositoriesList);
        this.hideRepository();
    }

    public void displayContent(String repository, String workspace, String path, boolean changeHistory) {
        this.contents.show(repository, workspace, path, changeHistory);
        this.displayRepository(repository);
        this.display((Canvas)this.contents);
        this.changeRepositoryInURL(repository, changeHistory);
    }

    public void displayContent(String repository, boolean changeHistory) {
        this.contents.show(repository, changeHistory);
        this.displayRepository(repository);
        this.display((Canvas)this.contents);
        this.changeRepositoryInURL(repository, changeHistory);
    }

    public void display(Canvas view) {
        Canvas[] members;
        for (Canvas canvas : members = this.viewPort.getMembers()) {
            canvas.setVisible(false);
            this.viewPort.removeChild(canvas);
        }
        this.viewPort.addMember(view);
        view.setVisible(true);
        view.show();
    }

    private VLayout strut(int height) {
        VLayout s = new VLayout();
        s.setHeight(height);
        return s;
    }
}

