/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.shared;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.CloseClickHandler;
import com.smartgwt.client.widgets.events.CloseClientEvent;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.SpacerItem;
import com.smartgwt.client.widgets.form.fields.SubmitItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VStack;

public abstract class ModalDialog {
    private Window window = new Window();
    private DynamicForm form = new DynamicForm();
    private SubmitItem confirmButton = new SubmitItem("OK");
    private SubmitItem cancelButton = new SubmitItem("Cancel");
    private VStack vStack = new VStack();

    public ModalDialog(String title, int width, int height) {
        this.form.setNumCols(2);
        this.form.setPadding(Integer.valueOf(25));
        this.vStack.setTop(10);
        this.vStack.addMember((Canvas)this.form);
        this.window.addChild((Canvas)this.vStack);
        this.window.setTitle(title);
        this.window.setCanDragReposition(Boolean.valueOf(true));
        this.window.setCanDragResize(Boolean.valueOf(false));
        this.window.setShowMinimizeButton(Boolean.valueOf(false));
        this.window.setShowCloseButton(Boolean.valueOf(true));
        this.window.setWidth(width);
        this.window.setHeight(height);
        this.window.setAutoCenter(Boolean.valueOf(true));
        this.window.addCloseClickHandler(new CloseClickHandler(){

            public void onCloseClick(CloseClientEvent event) {
                ModalDialog.this.hide();
            }
        });
        this.confirmButton.setTitle("OK");
        this.confirmButton.setWidth(100);
        this.confirmButton.setStartRow(Boolean.valueOf(true));
        this.confirmButton.setEndRow(Boolean.valueOf(false));
        this.confirmButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ModalDialog.this.onConfirm(event);
                ModalDialog.this.hide();
            }
        });
        this.cancelButton.setTitle("Cancel");
        this.cancelButton.setWidth(100);
        this.cancelButton.setStartRow(Boolean.valueOf(false));
        this.cancelButton.setEndRow(Boolean.valueOf(true));
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ModalDialog.this.hide();
            }
        });
    }

    protected void addMember(Canvas canvas) {
        this.vStack.addMember(canvas);
    }

    public void setControls(FormItem ... items) {
        FormItem[] controls = new FormItem[items.length + 3];
        int i = 0;
        for (FormItem item : items) {
            controls[i++] = item;
        }
        controls[i++] = new SpacerItem();
        controls[i++] = this.confirmButton;
        controls[i++] = this.cancelButton;
        this.form.setItems(controls);
    }

    public void showModal() {
        this.window.show();
    }

    public void hide() {
        this.window.hide();
    }

    public abstract void onConfirm(ClickEvent var1);

    public void setAction(String action) {
        this.form.setAction(action);
    }

    public void submitForm() {
        this.form.submitForm();
    }

    protected DynamicForm form() {
        return this.form;
    }

    protected Window window() {
        return this.window;
    }
}

