/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;

public class BackupExportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private File tempDir;
    private Logger logger = Logger.getLogger((String)"Servlet");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fname = request.getParameter("file");
        String qs = request.getQueryString();
        this.logger.debug("--------- Query string=" + qs, new Object[0]);
        File file = new File(this.tempDir.getAbsoluteFile() + File.separator + fname);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        File zipFile = new File(this.tempDir.getAbsolutePath() + File.separator + "bak.zip");
        FileUtil.zipDir((String)file.getAbsolutePath(), (String)zipFile.getAbsolutePath());
        response.setHeader("Content-Type", "application/zip");
        response.setHeader("Content-Length", String.valueOf(zipFile.length()));
        response.setHeader("Content-disposition", "attachment;filename=\"bak.zip\"");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(zipFile));
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        IoUtil.write((InputStream)bis, (OutputStream)bos);
        bos.flush();
        bos.close();
        bis.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    public void init() {
        ServletContext servletContext = this.getServletConfig().getServletContext();
        this.tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
    }
}

