/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.contents;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.client.peditor.BaseEditor;
import org.modeshape.web.client.peditor.ValueEditor;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrProperty;

public class PropertiesEditor
extends TabGrid<PropertyRecord, JcrProperty> {
    private JcrNode node;
    private final Contents contents;

    public PropertiesEditor(Contents contents) {
        super("Properties");
        this.contents = contents;
    }

    public void show(JcrNode node) {
        this.node = node;
        this.setValues(node.getProperties());
    }

    protected PropertyRecord[] records() {
        PropertyRecord[] records = new PropertyRecord[100];
        for (int i = 0; i < records.length; ++i) {
            records[i] = new PropertyRecord();
        }
        return records;
    }

    @Override
    protected HLayout tableHeader() {
        HLayout header = new HLayout();
        header.setHeight(30);
        header.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Name</b>");
        name.setWidth100();
        Label value = new Label("<b>Value</b>");
        value.setWidth100();
        header.addMember((Canvas)name);
        header.addMember((Canvas)value);
        return header;
    }

    @Override
    protected HLayout toolBar() {
        HLayout header = new HLayout();
        header.setBackgroundColor("#ffffff");
        header.setAlign(Alignment.LEFT);
        header.setDefaultLayoutAlign(Alignment.LEFT);
        header.setLayoutAlign(Alignment.LEFT);
        header.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        header.setLayoutAlign(VerticalAlignment.CENTER);
        header.setAlign(VerticalAlignment.CENTER);
        header.setHeight(30);
        header.setContents("Click respective to edit property value");
        return header;
    }

    @Override
    protected void updateRecord(int pos, PropertyRecord record, JcrProperty value) {
        record.setValue(value);
    }

    protected class PropertyRecord
    extends HLayout {
        private static final int RECORD_HEIGHT = 30;
        private Label name = new Label();
        private Label value = new Label();
        private Button editButton = new Button();
        private ValueEditor<String> editor;

        public PropertyRecord() {
            this.setStyleName("grid");
            this.setHeight(30);
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setIcon("icons/sprocket.png");
            this.name.setStyleName("text");
            this.name.setWidth100();
            this.value.setStyleName("text");
            this.value.setWidth100();
            this.value.setOverflow(Overflow.HIDDEN);
            this.value.setAlign(Alignment.RIGHT);
            this.value.setLayoutAlign(Alignment.RIGHT);
            this.editButton.setTitle("...");
            this.editButton.setWidth(30);
            this.editButton.setHeight(30);
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.value);
            this.addMember((Canvas)this.editButton);
        }

        private void setValue(final JcrProperty property) {
            this.name.setContents(property.getName());
            this.value.setContents(property.getDisplayValue());
            this.editor = BaseEditor.getValueEditor(property.getName(), property.getType(), PropertiesEditor.this.contents);
            this.editButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    PropertyRecord.this.editor.setValue(PropertiesEditor.this.node, property.getName(), property.getValue());
                }
            });
        }
    }
}

