/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.repo;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.shared.RepositoryName;

public class RepositoriesList
extends VLayout {
    private RepositoryItem[] items = new RepositoryItem[100];
    private JcrServiceAsync jcrService;
    private Console console;
    private String selected;

    public RepositoriesList(Console console, JcrServiceAsync jcrService) {
        this.console = console;
        this.jcrService = jcrService;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new RepositoryItem();
            this.addMember((Canvas)this.items[i]);
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public void show(Collection<RepositoryName> repos) {
        int i;
        for (i = 0; i < this.items.length; ++i) {
            this.items[i].setVisible(false);
        }
        i = 0;
        for (RepositoryName repo : repos) {
            this.items[i++].show(repo.getName(), repo.getDescriptor());
        }
    }

    public void load() {
        this.jcrService.getRepositories(new AsyncCallback<Collection<RepositoryName>>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Collection<RepositoryName> result) {
                try {
                    RepositoriesList.this.console.hideRepository();
                    RepositoriesList.this.show(result);
                    RepositoriesList.this.console.display((Canvas)RepositoriesList.this);
                }
                catch (Exception e) {
                    SC.say((String)e.getMessage());
                }
            }
        });
    }

    public void select(String repository, String workspace, String path, boolean changeHistory) {
        this.selected = repository;
        this.console.displayContent(repository, workspace, path, changeHistory);
    }

    private class RepositoryItem
    extends VLayout {
        private Label name = new Label();
        private Canvas descriptor = new Label();

        public RepositoryItem() {
            this.setVisible(false);
            this.setStyleName("repository");
            this.name.setHeight(30);
            this.name.setStyleName("repository-name");
            this.name.setIcon("icons/logo-1.png");
            this.name.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Label repo = (Label)event.getSource();
                    RepositoriesList.this.selected = repo.getContents();
                    RepositoriesList.this.console.displayContent(RepositoriesList.this.selected, true);
                }
            });
            this.addMember((Canvas)this.name);
            this.addMember(this.descriptor);
        }

        public void show(String name, String descriptor) {
            this.name.setContents(name);
            this.descriptor.setContents(descriptor);
            this.show();
        }
    }
}

