/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.web.server.Connector;
import org.modeshape.web.server.LRepository;
import org.modeshape.web.server.impl.LRepositoryImpl;
import org.modeshape.web.server.impl.RepositoryList;
import org.modeshape.web.shared.RemoteException;
import org.modeshape.web.shared.RepositoryName;

public class JsonConfigConnectorImpl
implements Connector {
    private static final long serialVersionUID = 1L;
    private transient HashMap<String, LRepository> repositories = new HashMap();
    private transient Collection<RepositoryName> repositoryNames;
    private transient Credentials credentials;
    private transient String userName;
    private transient ServletContext context;
    private transient ModeShapeEngine engine;
    private RepositoryList repoList;
    private static final Logger logger = Logger.getLogger(JsonConfigConnectorImpl.class);

    @Override
    public void start(ServletContext context) throws RemoteException {
        String urlString = context.getInitParameter("config-url");
        this.repositoryNames = new ArrayList<RepositoryName>();
        this.engine = new ModeShapeEngine();
        this.engine.start();
        try {
            URL configURL = this.getClass().getClassLoader().getResource(urlString);
            RepositoryConfiguration config = RepositoryConfiguration.read((URL)configURL);
            this.engine.deploy(config);
            this.repoList = new RepositoryList(this.engine);
            this.repositoryNames = this.repoList.getRepositories(null);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public void login(String username, String password) throws RemoteException {
        this.userName = username;
        if (username == null) {
            this.credentials = null;
        }
        this.credentials = password == null ? new SimpleCredentials(username, null) : new SimpleCredentials(username, password.toCharArray());
        this.repositoryNames = this.repoList.getRepositories(this.credentials);
    }

    @Override
    public void logout() {
        this.credentials = null;
        this.userName = null;
        try {
            this.repositoryNames = this.repoList.getRepositories(null);
        }
        catch (RemoteException e) {
            this.repositoryNames.clear();
        }
    }

    @Override
    public String userName() {
        return this.userName;
    }

    @Override
    public Collection<RepositoryName> getRepositories() {
        return this.repositoryNames;
    }

    @Override
    public LRepository find(String name) throws RemoteException {
        if (!this.repositories.containsKey(name)) {
            try {
                logger.debug("Starting repository: " + name, new Object[0]);
                this.repositories.put(name, new LRepositoryImpl(this.context, this.engine.getRepository(name), this.credentials));
            }
            catch (Exception e) {
                logger.debug("Could not start repository " + name, new Object[]{e});
                throw new RemoteException(e.getMessage());
            }
        }
        return this.repositories.get(name);
    }

    @Override
    public Collection<RepositoryName> search(String name) {
        ArrayList<RepositoryName> list = new ArrayList<RepositoryName>();
        for (RepositoryName n : this.repositoryNames) {
            if (!n.getName().contains(name) && !n.getDescriptor().contains(name)) continue;
            list.add(n);
        }
        return list;
    }
}

