/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server.impl;

import java.io.File;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.BackupOptions;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.RestoreOptions;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.web.server.LRepository;
import org.modeshape.web.server.impl.BackupUsrOptions;
import org.modeshape.web.server.impl.RestoreUsrOptions;
import org.modeshape.web.shared.BackupParams;
import org.modeshape.web.shared.RemoteException;
import org.modeshape.web.shared.RestoreParams;

public class LRepositoryImpl
implements LRepository {
    private Credentials creds;
    private JcrRepository repository;
    private transient ServletContext context;
    private transient File tempDir;
    private HashMap<String, javax.jcr.Session> sessions = new HashMap();
    private String[] workspaces;
    private static final Logger logger = Logger.getLogger(LRepositoryImpl.class);

    public LRepositoryImpl(ServletContext context, JcrRepository repository, Credentials creds) throws LoginException, RepositoryException {
        this.context = context;
        this.creds = creds;
        assert (repository != null);
        this.repository = repository;
        logger.debug("Logging to repository " + repository + " as " + creds, new Object[0]);
        JcrSession session = creds != null ? repository.login(creds) : repository.login();
        this.sessions.put(session.getWorkspace().getName(), (javax.jcr.Session)session);
        this.workspaces = session.getWorkspace().getAccessibleWorkspaceNames();
        logger.debug("[" + this.repository.getName() + "] available workspaces " + this.wsnames(), new Object[0]);
        this.tempDir = (File)context.getAttribute("javax.servlet.context.tempdir");
    }

    @Override
    public String name() {
        return this.repository.getName();
    }

    @Override
    public String[] getWorkspaces() {
        logger.debug("[" + this.repository.getName() + "] Requested workspaces " + this.wsnames(), new Object[0]);
        return this.workspaces;
    }

    private String wsnames() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (int i = 0; i < this.workspaces.length - 1; ++i) {
            builder.append(this.workspaces[i]);
            builder.append(",");
        }
        builder.append(this.workspaces[this.workspaces.length - 1]);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public javax.jcr.Session session(String workspace) throws RemoteException {
        if (this.sessions.containsKey(workspace)) {
            logger.debug("[" + this.repository.getName() + "] has already session to " + workspace, new Object[0]);
            return this.sessions.get(workspace);
        }
        try {
            logger.debug("[" + this.repository.getName() + "] has not yet session to " + workspace, new Object[0]);
            JcrSession session = this.creds != null ? this.repository.login(this.creds, workspace) : this.repository.login(workspace);
            this.sessions.put(workspace, (javax.jcr.Session)session);
            return session;
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private javax.jcr.Session session() {
        return this.sessions.values().iterator().next();
    }

    @Override
    public Repository repository() {
        return this.repository;
    }

    @Override
    public void backup(String name, BackupParams options) throws RemoteException {
        try {
            File dir = new File(this.tempDir.getAbsolutePath() + File.separator + name);
            RepositoryManager mgr = ((Session)this.session()).getWorkspace().getRepositoryManager();
            mgr.backupRepository(dir, (BackupOptions)new BackupUsrOptions(options));
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public void restore(String name, RestoreParams options) throws RemoteException {
        try {
            File dir = new File(this.tempDir.getAbsolutePath() + File.separator + name);
            RepositoryManager mgr = ((Session)this.session()).getWorkspace().getRepositoryManager();
            mgr.restoreRepository(dir, (RestoreOptions)new RestoreUsrOptions(options));
            this.sessions.clear();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void importXML(String workspace) throws RemoteException {
        try {
            Workspace ws = ((Session)this.session(workspace)).getWorkspace();
            ws.importXML(workspace, null, 0);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }
}

