/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.web.shared.RemoteException;
import org.modeshape.web.shared.RepositoryName;

public class RepositoryList {
    private final ModeShapeEngine engine;

    public RepositoryList(ModeShapeEngine engine) {
        this.engine = engine;
    }

    public Collection<RepositoryName> getRepositories(Credentials creds) throws RemoteException {
        ArrayList<RepositoryName> list = new ArrayList<RepositoryName>();
        for (String name : this.engine.getRepositoryNames()) {
            JcrRepository repo;
            try {
                repo = this.engine.getRepository(name);
                this.testLogin((Repository)repo, creds);
            }
            catch (LoginException | NoSuchRepositoryException e) {
                continue;
            }
            catch (RepositoryException e) {
                throw new RemoteException(e.getMessage());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("<b>Vendor: </b>");
            builder.append(repo.getDescriptor("jcr.repository.vendor"));
            builder.append("</br>");
            builder.append("<b>Version: </b>");
            builder.append(repo.getDescriptor("jcr.repository.version"));
            builder.append("</br>");
            builder.append(repo.getDescriptor("jcr.repository.vendor.url"));
            builder.append("</br>");
            String descriptor = builder.toString();
            list.add(new RepositoryName(name, descriptor));
        }
        return list;
    }

    private void testLogin(Repository repository, Credentials credentials) throws LoginException, RepositoryException {
        try {
            repository.login();
        }
        catch (LoginException e) {
            if (credentials == null) {
                throw e;
            }
            repository.login(credentials);
        }
    }
}

