/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.chart;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.widgetideas.graphics.client.Color;
import com.google.gwt.widgetideas.graphics.client.GWTCanvas;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.Format;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;

public class Chart
extends VLayout {
    private static final int LABEL_SIZE = 30;
    private static final int Y_SCALE = 10;
    private YAxis yAxis = new YAxis();
    private XAxis xAxis = new XAxis();
    private int X;
    private int Y;
    private ViewPort viewPort = new ViewPort();
    private GWTCanvas canvas;

    public Chart(String title) {
        this.setWidth100();
        this.setHeight100();
        this.init();
    }

    public final void init() {
        Title title = new Title("");
        title.setWidth100();
        title.setHeight(30);
        this.addMember((Canvas)title);
        HLayout layout = new HLayout();
        layout.setWidth100();
        layout.setHeight100();
        layout.addMember((Canvas)this.yAxis);
        layout.addMember((Canvas)this.viewPort);
        this.addMember((Canvas)layout);
        this.addMember((Canvas)this.xAxis);
        this.addMember((Canvas)new Footer());
    }

    public void drawChart(String[] xl, double[] x, double[] y1, double[] y2, double[] y3) {
        this.viewPort.drawChart(xl, x, y1, y2, y3);
    }

    private class ViewPort
    extends HLayout {
        private final Color[] COLOR = new Color[]{Color.RED, Color.BLUE, Color.GREEN};

        public ViewPort() {
            this.setWidth100();
            this.setHeight100();
            this.setBorder("2px solid black");
        }

        private void drawGrid(int N, int M) {
            if (Chart.this.canvas == null) {
                Chart.this.canvas = new GWTCanvas(this.getWidth().intValue(), this.getHeight().intValue());
                this.addMember((Widget)Chart.this.canvas);
            } else {
                Chart.this.canvas.clear();
            }
            Chart.this.X = Chart.this.canvas.getCoordWidth();
            Chart.this.Y = Chart.this.canvas.getCoordHeight();
            double dx = Chart.this.X / N;
            double dy = Chart.this.Y / M;
            Chart.this.canvas.beginPath();
            Chart.this.canvas.setLineWidth(1.0);
            Chart.this.canvas.setStrokeStyle(Color.BLACK);
            for (int i = 0; i < N; ++i) {
                double x = dx * (double)(i + 1);
                Chart.this.canvas.moveTo(x, 0.0);
                Chart.this.canvas.lineTo(x, (double)Chart.this.Y);
            }
            int j = M - 1;
            for (int i = 0; i < M; ++i) {
                double y = (double)Chart.this.Y - dy * (double)j--;
                Chart.this.canvas.moveTo(0.0, y);
                Chart.this.canvas.lineTo((double)Chart.this.X, y);
            }
            Chart.this.canvas.stroke();
        }

        private void drawLine(double[] y, double min, double max, Color color) {
            Chart.this.canvas.beginPath();
            Chart.this.canvas.setLineWidth(2.0);
            Chart.this.canvas.setStrokeStyle(color);
            double xScale = Chart.this.X / y.length;
            double yScale = (double)Chart.this.Y / (max - min);
            for (int i = 0; i < y.length - 1; ++i) {
                Chart.this.canvas.moveTo((double)i * xScale, (double)Chart.this.Y - (y[i] - min) * yScale);
                Chart.this.canvas.lineTo((double)(i + 1) * xScale, (double)Chart.this.Y - (y[i + 1] - min) * yScale);
            }
            Chart.this.canvas.stroke();
        }

        private String[] yLabels(double[] ... y) {
            String[] labels = new String[10];
            double min = this.min(y);
            double max = this.max(y);
            double s = (max - min) / 10.0;
            for (int i = 0; i < 10; ++i) {
                labels[i] = Format.toUSString((double)(min + (double)i * s), (int)2);
            }
            return labels;
        }

        public void drawChart(String[] xLabels, double[] x, double[] ... y) {
            String[] yLabels = this.yLabels(y);
            Chart.this.yAxis.drawLabels(yLabels);
            Chart.this.xAxis.drawLabels(xLabels);
            double min = this.min(y);
            double max = this.max(y);
            this.drawGrid(xLabels.length, yLabels.length);
            for (int i = 0; i < y.length; ++i) {
                this.drawLine(y[i], min, max, this.COLOR[i]);
            }
        }

        private double min(double[] ... x) {
            double min = x[0][0];
            for (int j = 0; j < x.length; ++j) {
                for (int i = 0; i < x[j].length; ++i) {
                    if (!(x[j][i] < min)) continue;
                    min = x[j][i];
                }
            }
            return min;
        }

        private double max(double[] ... x) {
            double max = x[0][0];
            for (int j = 0; j < x.length; ++j) {
                for (int i = 0; i < x[j].length; ++i) {
                    if (!(x[j][i] > max)) continue;
                    max = x[j][i];
                }
            }
            return max;
        }
    }

    private class XLabel
    extends Label {
        public XLabel(String v) {
            this.setWidth100();
            this.setHeight100();
            this.setContents(v);
            this.setAlign(Alignment.LEFT);
            this.setLayoutAlign(Alignment.LEFT);
        }
    }

    private class XAxis
    extends HLayout {
        public XAxis() {
            this.setHeight(30);
            this.setWidth100();
        }

        private void clean() {
            Canvas[] members = this.getMembers();
            for (int i = 0; i < members.length; ++i) {
                this.removeMember(members[i]);
            }
        }

        public void drawLabels(String[] x) {
            this.clean();
            Label strut = new Label();
            strut.setWidth(30);
            strut.setHeight(30);
            this.addMember((Canvas)strut);
            for (int i = 0; i < x.length; ++i) {
                this.addMember((Canvas)new XLabel(x[i]));
            }
        }
    }

    private class YLabel
    extends Label {
        public YLabel(String v) {
            this.setWidth100();
            this.setHeight100();
            this.setContents(v);
            this.setAlign(Alignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setLayoutAlign(VerticalAlignment.BOTTOM);
            this.setValign(VerticalAlignment.BOTTOM);
        }
    }

    private class YAxis
    extends VLayout {
        public YAxis() {
            this.setWidth(30);
            this.setHeight100();
        }

        private void clean() {
            Canvas[] members = this.getMembers();
            for (int i = 0; i < members.length; ++i) {
                this.removeMember(members[i]);
            }
        }

        public void drawLabels(String[] x) {
            this.clean();
            int j = x.length - 1;
            for (int i = 0; i < x.length; ++i) {
                this.addMember((Canvas)new YLabel(x[j--]));
            }
        }
    }

    private class Footer
    extends VLayout {
        public Footer() {
            HLayout layout = new HLayout();
            this.addMember((Canvas)layout);
            Label strut = new Label();
            strut.setWidth(30);
            Label min = new Label("<span style=\"color:red\">Min</span>");
            Label max = new Label("<span style=\"color:blue\">Max</span>");
            Label avg = new Label("<span style=\"color:green\">Average</span>");
            layout.addMember((Canvas)strut);
            layout.addMember((Canvas)min);
            layout.addMember((Canvas)max);
            layout.addMember((Canvas)avg);
        }
    }

    private class Title
    extends VLayout {
        public Title(String title) {
            this.setContents(title);
        }
    }
}

