/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.contents;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.contents.RefreshSessionDialog;
import org.modeshape.web.shared.Columns;

public class WorkspacePanel
extends Columns {
    private static final String STYLE_NAME = "viewport";
    private static final int LAYOUT_MARGIN = 5;
    private static final String COL2_WIDTH = "25%";
    private final Contents contents;
    private final Column1 col1 = new Column1();
    private final Column2 col2 = new Column2();
    private RefreshSessionDialog refreshDialog;

    public WorkspacePanel(Contents contents) {
        super(1, 5);
        this.contents = contents;
        this.refreshDialog = new RefreshSessionDialog(contents);
        this.setStyleName(STYLE_NAME);
        this.setLayoutMargin(5);
        HLayout strut = new HLayout();
        strut.setWidth(40);
        this.addMember((Canvas)this.col1);
        this.addMember((Canvas)strut);
        this.addMember((Canvas)this.col2);
    }

    public void setEnabled(boolean enabled) {
        this.col1.setEnabled(enabled);
    }

    public void setWorkspaceNames(String[] values) {
        this.col2.combo.setValueMap(values);
        if (values.length > 0) {
            this.col2.combo.setValue(values[0]);
        }
    }

    public String getSelectedWorkspace() {
        return this.col2.combo.getValueAsString();
    }

    private class Column1
    extends VLayout {
        private final Label saveButton = new Label();

        public Column1() {
            this.setWidth100();
            this.addMember((Canvas)this.Row1());
            this.addMember((Canvas)this.Row2());
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                this.saveButton.enable();
                this.saveButton.setStyleName("button-label");
            } else {
                this.saveButton.disable();
                this.saveButton.setStyleName("button-label-disable");
            }
            this.saveButton.redraw();
        }

        private HLayout Row1() {
            Columns top = new Columns(1, 5);
            top.setAlign(Alignment.LEFT);
            top.setWidth100();
            top.setHeight(30);
            Label caption = new Label();
            caption.setContents("Session ");
            caption.setAutoWidth();
            this.saveButton.setIcon("icons/cd.png");
            this.saveButton.setWidth(16);
            this.saveButton.setTooltip("Save session");
            this.saveButton.setStyleName("button-label-disabled");
            this.saveButton.setContents("Save");
            this.saveButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkspacePanel.this.contents.save();
                }
            });
            Label refreshButton = new Label();
            refreshButton.setIcon("icons/apply.png");
            refreshButton.setWidth(16);
            refreshButton.setTooltip("Refresh session");
            refreshButton.setStyleName("button-label");
            refreshButton.setContents("Refresh");
            refreshButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkspacePanel.this.refreshDialog.showModal();
                }
            });
            top.addMember((Canvas)caption);
            top.addStrut(5);
            top.addMember((Canvas)this.saveButton);
            top.addStrut(5);
            top.addMember((Canvas)refreshButton);
            return top;
        }

        private HLayout Row2() {
            Columns panel = new Columns(1, 5);
            panel.setWidth100();
            panel.setHeight(50);
            panel.setStyleName("session-hint");
            Label hint = new Label();
            hint.setWidth100();
            hint.setHeight100();
            hint.setContents("Each Session object is associated one-to-one with a Workspace object. The Workspace object represents a \"view\" of an actual repository workspace entity as seen through the authorization settings of its associated Session. ");
            panel.addMember((Canvas)hint);
            return panel;
        }
    }

    private class Column2
    extends Columns {
        private ComboBoxItem combo;

        public Column2() {
            super(1, 5);
            this.combo = new ComboBoxItem();
            this.setWidth(WorkspacePanel.COL2_WIDTH);
            DynamicForm form = new DynamicForm();
            form.setFields(new FormItem[]{this.combo});
            this.combo.setTitle("Workspace");
            this.combo.setWidth(250);
            this.combo.addChangedHandler(new ChangedHandler(){

                public void onChanged(ChangedEvent event) {
                    WorkspacePanel.this.contents.changeWorkspace((String)event.getValue());
                }
            });
            this.addMember((Canvas)form);
        }
    }
}

