/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.web.jcr.rest.client.domain.Server;

public final class ServerTest {
    private static final String URL1 = "file:/tmp/temp.txt";
    private static final String URL2 = "http:www.redhat.com";
    private static final String USER1 = "user1";
    private static final String USER2 = "user2";
    private static final String PSWD1 = "pwsd1";
    private static final String PSWD2 = "pwsd2";
    private static Server SERVER1 = new Server("file:/tmp/temp.txt", "user1", "pwsd1");

    @Test
    public void shouldBeEqualIfHavingSameProperies() {
        Assert.assertThat((Object)SERVER1, (Matcher)IsEqual.equalTo((Object)new Server(SERVER1.getUrl(), SERVER1.getUser(), SERVER1.getPassword())));
    }

    @Test
    public void shouldHashToSameValueIfEquals() {
        HashSet<Server> set = new HashSet<Server>();
        set.add(SERVER1);
        set.add(new Server(SERVER1.getUrl(), SERVER1.getUser(), SERVER1.getPassword()));
        Assert.assertThat((Object)set.size(), (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test(expected=RuntimeException.class)
    public void shouldNotAllowNullUrl() {
        new Server(null, USER1, PSWD1);
    }

    @Test
    public void shouldHaveSameKey() {
        Assert.assertThat((Object)SERVER1.hasSameKey(new Server(SERVER1.getUrl(), SERVER1.getUser(), SERVER1.getPassword())), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBeEqualIfPropertiesAreDifferent() {
        Assert.assertThat((Object)SERVER1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Server(URL2, SERVER1.getUser(), SERVER1.getPassword())))));
        Assert.assertThat((Object)SERVER1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Server(SERVER1.getUrl(), USER2, SERVER1.getPassword())))));
        Assert.assertThat((Object)SERVER1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Server(SERVER1.getUrl(), SERVER1.getUser(), PSWD2)))));
    }

    @Test
    public void shouldNotHaveSameKey() {
        Assert.assertThat((Object)SERVER1.hasSameKey(new Server(URL2, SERVER1.getUser(), SERVER1.getPassword())), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)SERVER1.hasSameKey(new Server(SERVER1.getUrl(), USER2, SERVER1.getPassword())), (Matcher)Is.is((Object)false));
    }
}

