/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.web.jcr.rest.client.IRestClient;
import org.modeshape.web.jcr.rest.client.Status;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.FileNode;
import org.modeshape.web.jcr.rest.client.json.JsonRestClient;

public final class JsonRestClientTest {
    private static final String PSWD = "password";
    private static final String USER = "dnauser";
    private static final Server SERVER = new Server("http://localhost:8090/resources", "dnauser", "password");
    private static final String REPOSITORY_NAME = "mode:repository";
    private static final Repository REPOSITORY1 = new Repository("mode:repository", SERVER);
    private static final String WORKSPACE_NAME = "default";
    private static final Workspace WORKSPACE1 = new Workspace("default", REPOSITORY1);
    private static final String WORKSPACE_PATH = "/myproject/myfolder/";
    private static final String FILE_PATH = "/myproject/myfolder/document.txt";
    private static final String BINARY_FILE_PATH = "/myproject/myfolder/picture.jpg";
    private static final String WORKSPACE_UNUSUALPATH = "/myproject/My.Test - Folder/";
    private static final String FILE_UNUSUALPATH = "/myproject/My.Test - Folder/Test File_.a-().txt";
    private IRestClient restClient;

    @Before
    public void beforeEach() {
        this.restClient = new JsonRestClient();
    }

    @Test
    public void shouldGetRepositories() throws Exception {
        Collection repositories = this.restClient.getRepositories(SERVER);
        Assert.assertThat((Object)repositories.size(), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertThat(repositories.iterator().next(), (Matcher)Is.is((Object)REPOSITORY1));
    }

    @Test
    public void shouldGetWorkspaces() throws Exception {
        Collection workspaces = this.restClient.getWorkspaces(REPOSITORY1);
        Assert.assertThat((Object)workspaces.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(workspaces.iterator().next(), (Matcher)Is.is((Object)WORKSPACE1));
    }

    @Test
    public void shouldNotUnpublishNonexistentFile() throws Exception {
        File file = new File("bogusfile");
        Status status = this.restClient.unpublish(WORKSPACE1, WORKSPACE_PATH, file);
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
        }
        Assert.assertThat((String)status.getMessage(), (Object)status.isInfo(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldPublishBinaryResource() throws Exception {
        URL binaryFile = this.getClass().getResource(BINARY_FILE_PATH);
        Assert.assertThat((Object)binaryFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(binaryFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file);
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
        }
        Assert.assertThat((Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, file).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, file);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void shouldPublishTextResource() throws Exception {
        URL textFile = this.getClass().getResource(FILE_PATH);
        Assert.assertThat((Object)textFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(textFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file);
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
        }
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, file).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, file);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void shouldPublishResourcesHavingNonLettersNonNumbersInName() throws Exception {
        URL textFile = this.getClass().getResource(FILE_UNUSUALPATH);
        Assert.assertThat((Object)textFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(textFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_UNUSUALPATH, file);
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
        }
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_UNUSUALPATH, file), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldUnpublish() throws Exception {
        this.shouldPublishTextResource();
        URL textFile = this.getClass().getResource(FILE_PATH);
        File file = new File(textFile.toURI());
        Status status = this.restClient.unpublish(WORKSPACE1, WORKSPACE_PATH, file);
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
        }
        Assert.assertThat((Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)false));
    }
}

