/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;

public final class NodeTypeTest {
    private static final String NAME1 = "name1";
    private static final String NAME2 = "name2";
    private static final Server SERVER1 = new Server("file:/tmp/temp.txt/resources", "user", "pswd");
    private static final Server SERVER2 = new Server("http:www.redhat.com/resources", "user", "pswd");
    private static final Repository REPOSITORY1 = new Repository("name1", SERVER1);
    private static final Repository REPOSITORY2 = new Repository("name2", SERVER2);
    private static final Workspace WORKSPACE1 = new Workspace("name1", REPOSITORY1);

    @Test
    public void shouldBeEqualIfHavingSameProperies() {
        Assert.assertThat((Object)WORKSPACE1, (Matcher)IsEqual.equalTo((Object)new Workspace(WORKSPACE1.getName(), WORKSPACE1.getRepository())));
    }

    @Test
    public void shouldHashToSameValueIfEquals() {
        HashSet<Workspace> set = new HashSet<Workspace>();
        set.add(WORKSPACE1);
        set.add(new Workspace(WORKSPACE1.getName(), WORKSPACE1.getRepository()));
        Assert.assertThat((Object)set.size(), (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowNullName() {
        new Workspace(null, REPOSITORY1);
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowNullRepository() {
        new Workspace(NAME1, null);
    }

    @Test
    public void shouldNotBeEqualIfSameNameButDifferentRepository() {
        Assert.assertThat((Object)WORKSPACE1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Workspace(WORKSPACE1.getName(), REPOSITORY2)))));
    }

    @Test
    public void shouldNotBeEqualIfSameRepositoryButDifferentName() {
        Assert.assertThat((Object)WORKSPACE1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Workspace(NAME2, WORKSPACE1.getRepository())))));
    }
}

