/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.domain.NodeType;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;
import org.modeshape.web.jcr.rest.client.json.WorkspaceNode;

@Immutable
public final class NodeTypeNode
extends JsonNode {
    private final Workspace workspace;
    private final String depth;
    private Map<String, NodeType> nodeTypeMap = new HashMap<String, NodeType>();

    public NodeTypeNode(Workspace workspace, String relative_path, String nodeDepth) throws Exception {
        super(relative_path);
        assert (workspace != null);
        this.workspace = workspace;
        this.depth = nodeDepth;
    }

    public String getPath() {
        return this.getId();
    }

    @Override
    public URL getUrl() throws Exception {
        WorkspaceNode workspaceNode = new WorkspaceNode(this.workspace);
        StringBuilder url = new StringBuilder(workspaceNode.getUrl().toString());
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        url.append(JsonUtils.encode(path));
        if (this.depth != null) {
            url.append(this.depth);
        }
        return new URL(url.toString());
    }

    public Collection<NodeType> getNodeTypes(String jsonResponse) throws Exception {
        CheckArg.isNotNull((Object)jsonResponse, (String)"jsonResponse");
        ArrayList<NodeType> nodetypes = new ArrayList<NodeType>();
        JSONObject body = new JSONObject(jsonResponse);
        this.processBody(body, nodetypes, null);
        return nodetypes;
    }

    protected void processBody(JSONObject body, Collection<NodeType> nodetypes, NodeType parentNodeType) throws Exception {
        NodeType parent = parentNodeType;
        parent = this.createNodeType(null, body, null);
        nodetypes.add(parent);
        this.nodeTypeMap.put(parent.getName(), parent);
        if (body.has("children")) {
            Object obj = body.get("children");
            if (obj instanceof JSONObject) {
                JSONObject children = (JSONObject)obj;
                Iterator itr = children.keys();
                while (itr.hasNext()) {
                    String key = JsonUtils.decode((String)itr.next());
                    Object child = children.get(key);
                    if (child == null) continue;
                    if (child instanceof JSONObject) {
                        JSONObject jsonchild = (JSONObject)child;
                        NodeType nodeType = this.createNodeType(key, jsonchild, parent);
                        nodetypes.add(nodeType);
                        this.processNodeType(nodeType, jsonchild, parent);
                        continue;
                    }
                    if (child instanceof JSONArray) {
                        JSONArray childarray = (JSONArray)child;
                        for (int idx = 0; idx < childarray.length(); ++idx) {
                            String cname = childarray.getString(idx);
                            NodeType childnodeType = this.createNodeType(cname, null, parent);
                            nodetypes.add(childnodeType);
                        }
                        continue;
                    }
                    throw new Exception("Program Error: didnt handle object type: " + child.getClass().getName());
                }
            } else if (obj instanceof JSONArray) {
                JSONArray childarray = (JSONArray)obj;
                for (int i = 0; i < childarray.length(); ++i) {
                    String cname = childarray.getString(i);
                    this.createNodeType(cname, null, parent);
                }
            } else {
                throw new Exception("Program Error: didnt handle object type: " + obj.getClass().getName());
            }
        }
    }

    private void processNodeType(NodeType nodeType, JSONObject child, NodeType parentNodeType) throws Exception {
        if (child.has("children")) {
            Object obj = child.get("children");
            if (obj instanceof JSONObject) {
                JSONObject children = (JSONObject)obj;
                Iterator itr = children.keys();
                while (itr.hasNext()) {
                    String childkey = JsonUtils.decode((String)itr.next());
                    Object childObj = children.get(childkey);
                    if (childObj instanceof JSONObject) {
                        JSONObject childJson = (JSONObject)childObj;
                        NodeType childnodeType = this.createNodeType(childkey, childJson, nodeType);
                        this.processNodeType(childnodeType, (JSONObject)childObj, nodeType);
                        continue;
                    }
                    throw new Exception("Program Error: class type not handled " + childObj.getClass().getName());
                }
            } else if (obj instanceof JSONArray) {
                JSONArray childarray = (JSONArray)obj;
                for (int i = 0; i < childarray.length(); ++i) {
                    String cname = childarray.getString(i);
                    this.createNodeType(cname, null, nodeType);
                }
            } else {
                throw new Exception("Program Error: didnt handle object type: " + obj.getClass().getName());
            }
        }
    }

    private NodeType createNodeType(String childkey, JSONObject childNode, NodeType parentNodeType) throws Exception {
        JSONObject jsonProperties = null;
        if (childNode == null) {
            NodeType type = new NodeType(childkey, this.workspace, null);
            if (parentNodeType != null) {
                parentNodeType.addChildNodeType(type);
            }
            return type;
        }
        if (!childNode.has("properties")) {
            NodeType type = new NodeType(childkey, this.workspace, null);
            if (parentNodeType != null) {
                parentNodeType.addChildNodeType(type);
            }
            return type;
        }
        Object cobj = childNode.get("properties");
        assert (cobj != null);
        jsonProperties = (JSONObject)cobj;
        Properties properties = new Properties();
        Iterator itr = jsonProperties.keys();
        while (itr.hasNext()) {
            String key = JsonUtils.decode((String)itr.next());
            Object obj = jsonProperties.get(key);
            if (obj == null) continue;
            if (obj instanceof JSONObject) {
                throw new Exception("Program Error: didnt handle object type: " + obj.getClass().getName());
            }
            properties.put(key, obj.toString());
        }
        String nodeName = childkey;
        NodeType childnodeType = null;
        if (nodeName == null) {
            nodeName = properties.getProperty("jcr:primaryType", childkey);
            childnodeType = new NodeType(nodeName, this.workspace, properties);
            if (parentNodeType != null) {
                parentNodeType.addChildNodeType(childnodeType);
            }
        } else if (childkey.equalsIgnoreCase("jcr:propertyDefinition")) {
            nodeName = properties.getProperty("jcr:name", childkey);
            childnodeType = new NodeType(nodeName, this.workspace, properties);
            if (parentNodeType != null) {
                parentNodeType.addPropertyDefinitionNodeType(childnodeType);
            }
        } else if (childkey.equalsIgnoreCase("jcr:childNodeDefinition")) {
            nodeName = properties.getProperty("jcr:name", childkey);
            childnodeType = new NodeType(nodeName, this.workspace, properties);
            if (parentNodeType != null) {
                parentNodeType.addChildNodeDefinitionNodeType(childnodeType);
            }
        } else if (properties.getProperty("jcr:nodeTypeName") != null) {
            nodeName = properties.getProperty("jcr:nodeTypeName", childkey);
            childnodeType = new NodeType(nodeName, this.workspace, properties);
            if (parentNodeType != null) {
                parentNodeType.addChildNodeType(childnodeType);
            }
        }
        if (nodeName == null) {
            nodeName = childkey != null ? childkey : "NotDefined";
        }
        CheckArg.isNotNull((Object)nodeName, (String)("nodeName ends up in null state for childkey: " + childkey));
        return childnodeType;
    }

    public NodeType getNodeType(String jsonResponse) throws Exception {
        CheckArg.isNotNull((Object)jsonResponse, (String)"jsonResponse");
        JSONObject jsonChild = new JSONObject(jsonResponse);
        Properties properties = new Properties();
        NodeType nodetype = null;
        Iterator itr = jsonChild.keys();
        while (itr.hasNext()) {
            String name = JsonUtils.decode((String)itr.next());
            Object obj = jsonChild.get(name);
            if (obj == null || !(obj instanceof JSONObject)) continue;
            JSONObject child = (JSONObject)obj;
            nodetype = new NodeType(name, this.workspace, properties);
            this.processNodeType(nodetype, child, null);
            return nodetype;
        }
        return null;
    }
}

