/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.request;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.core.request.AcceptHeaders;
import org.jboss.resteasy.core.request.QualityValue;
import org.jboss.resteasy.core.request.VariantQuality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDrivenNegotiation {
    private Map<MediaType, QualityValue> requestedMediaTypes = null;
    private Map<String, QualityValue> requestedCharacterSets = null;
    private Map<String, QualityValue> requestedEncodings = null;
    private Map<Locale, QualityValue> requestedLanguages = null;

    public void setAcceptHeaders(List<String> headerValues) {
        this.requestedMediaTypes = null;
        if (headerValues == null) {
            return;
        }
        Map<MediaType, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<MediaType, QualityValue> mapping = AcceptHeaders.getMediaTypeQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedMediaTypes = requested;
    }

    public void setAcceptCharsetHeaders(List<String> headerValues) {
        this.requestedCharacterSets = null;
        if (headerValues == null) {
            return;
        }
        Map<String, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<String, QualityValue> mapping = AcceptHeaders.getStringQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedCharacterSets = requested;
    }

    public void setAcceptEncodingHeaders(List<String> headerValues) {
        this.requestedEncodings = null;
        if (headerValues == null) {
            return;
        }
        Map<String, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<String, QualityValue> mapping = AcceptHeaders.getStringQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedEncodings = requested;
    }

    public void setAcceptLanguageHeaders(List<String> headerValues) {
        this.requestedLanguages = null;
        if (headerValues == null) {
            return;
        }
        Map<Locale, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<Locale, QualityValue> mapping = AcceptHeaders.getLocaleQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedLanguages = requested;
    }

    public Variant getBestMatch(List<Variant> available) {
        BigDecimal bestQuality = BigDecimal.ZERO;
        Variant bestOption = null;
        for (Variant option : available) {
            BigDecimal optionQuality;
            VariantQuality quality;
            if (!this.applyMediaType(option, quality = new VariantQuality()) || !this.applyCharacterSet(option, quality) || !this.applyEncoding(option, quality) || !this.applyLanguage(option, quality) || !ServerDrivenNegotiation.isBetterOption(bestQuality, bestOption, optionQuality = quality.getOverallQuality(), option)) continue;
            bestQuality = optionQuality;
            bestOption = option;
        }
        return bestOption;
    }

    private static boolean isBetterOption(BigDecimal bestQuality, Variant best, BigDecimal optionQuality, Variant option) {
        int signum;
        if (best == null) {
            return true;
        }
        MediaType bestType = best.getMediaType();
        MediaType optionType = option.getMediaType();
        if (bestType != null && optionType != null) {
            if (bestType.getType().equals(optionType.getType())) {
                if (bestType.getSubtype().equals(optionType.getSubtype())) {
                    int bestCount = bestType.getParameters().size();
                    int optionCount = optionType.getParameters().size();
                    if (optionCount > bestCount) {
                        return true;
                    }
                    if (optionCount < bestCount) {
                        return false;
                    }
                } else {
                    if ("*".equals(bestType.getSubtype())) {
                        return true;
                    }
                    if ("*".equals(optionType.getSubtype())) {
                        return false;
                    }
                }
            } else {
                if ("*".equals(bestType.getType())) {
                    return true;
                }
                if ("*".equals(optionType.getType())) {
                    return false;
                }
            }
        }
        if ((signum = bestQuality.compareTo(optionQuality)) != 0) {
            return signum < 0;
        }
        return ServerDrivenNegotiation.getExplicitness(best) < ServerDrivenNegotiation.getExplicitness(option);
    }

    private static int getExplicitness(Variant variant) {
        int explicitness = 0;
        if (variant.getMediaType() != null) {
            ++explicitness;
        }
        if (variant.getEncoding() != null) {
            ++explicitness;
        }
        if (variant.getLanguage() != null) {
            ++explicitness;
        }
        return explicitness;
    }

    private boolean applyMediaType(Variant option, VariantQuality quality) {
        Map<String, String> parameters;
        String subtype;
        if (this.requestedMediaTypes == null) {
            return true;
        }
        MediaType mediaType = option.getMediaType();
        if (mediaType == null) {
            return true;
        }
        String type = mediaType.getType();
        if ("*".equals(type)) {
            type = null;
        }
        if ("*".equals(subtype = mediaType.getSubtype())) {
            subtype = null;
        }
        if ((parameters = mediaType.getParameters()).isEmpty()) {
            parameters = null;
        }
        QualityValue bestQuality = QualityValue.NOT_ACCEPTABLE;
        int bestMatchCount = -1;
        for (MediaType requested : this.requestedMediaTypes.keySet()) {
            QualityValue qualityValue;
            int matchCount = 0;
            if (type != null) {
                String requestedType = requested.getType();
                if (requestedType.equals(type)) {
                    ++matchCount;
                } else if (!"*".equals(requestedType)) continue;
            }
            if (subtype != null) {
                String requestedSubtype = requested.getSubtype();
                if (requestedSubtype.equals(subtype)) {
                    ++matchCount;
                } else if (!"*".equals(requestedSubtype)) continue;
            }
            if (parameters != null) {
                Map<String, String> requestedParameters = requested.getParameters();
                if (!this.hasRequiredParameters(requestedParameters, parameters)) continue;
                matchCount += requestedParameters.size();
            }
            if (matchCount > bestMatchCount) {
                bestMatchCount = matchCount;
                bestQuality = this.requestedMediaTypes.get(requested);
                continue;
            }
            if (matchCount != bestMatchCount || bestQuality.compareTo(qualityValue = this.requestedMediaTypes.get(requested)) >= 0) continue;
            bestQuality = qualityValue;
        }
        if (!bestQuality.isAcceptable()) {
            return false;
        }
        quality.setMediaTypeQualityValue(bestQuality);
        return true;
    }

    private boolean hasRequiredParameters(Map<String, String> required, Map<String, String> available) {
        for (Map.Entry<String, String> requiredEntry : required.entrySet()) {
            String name = requiredEntry.getKey();
            String value = requiredEntry.getValue();
            String availableValue = available.get(name);
            if (!(availableValue == null && "charset".equals(name) ? this.requestedCharacterSets != null && !this.requestedCharacterSets.containsKey(null) && !this.requestedCharacterSets.containsKey(value) : !value.equals(availableValue))) continue;
            return false;
        }
        return true;
    }

    private boolean applyCharacterSet(Variant option, VariantQuality quality) {
        if (this.requestedCharacterSets == null) {
            return true;
        }
        MediaType mediaType = option.getMediaType();
        if (mediaType == null) {
            return true;
        }
        String charsetParameter = mediaType.getParameters().get("charset");
        if (charsetParameter == null) {
            return true;
        }
        QualityValue value = this.requestedCharacterSets.get(charsetParameter);
        if (value == null) {
            value = this.requestedCharacterSets.get(null);
        }
        if (value == null) {
            return false;
        }
        quality.setCharacterSetQualityValue(value);
        return true;
    }

    private boolean applyEncoding(Variant option, VariantQuality quality) {
        if (this.requestedEncodings == null) {
            return true;
        }
        String encoding = option.getEncoding();
        if (encoding == null) {
            return true;
        }
        QualityValue value = this.requestedEncodings.get(encoding);
        if (value == null) {
            value = this.requestedEncodings.get(null);
        }
        if (value == null) {
            return false;
        }
        quality.setEncodingQualityValue(value);
        return true;
    }

    private boolean applyLanguage(Variant option, VariantQuality quality) {
        if (this.requestedLanguages == null) {
            return true;
        }
        Locale language = option.getLanguage();
        if (language == null) {
            return true;
        }
        QualityValue value = this.requestedLanguages.get(language);
        if (value == null) {
            value = this.requestedLanguages.get(null);
        }
        if (value == null) {
            return false;
        }
        quality.setLanguageQualityValue(value);
        return true;
    }
}

