/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.web.jcr.rest.client.Utils;

public final class UtilsTest {
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static final String TEXT_MIMETYPE = "text/plain";
    private static final String XML_MIMETYPE = "application/xml";
    private static final String[] TEXT_EXTENSIONS = new String[]{"classpath", "debug", "epf", "ini", "lock", "mappings", "mf", "prefs", "properties", "readme", "svn-base"};
    private static final String[] XML_EXTENSIONS = new String[]{"launch", "project", "template", "xsd"};

    @Test
    public void shouldHaveCorrectMimetypeForEclipseTextFiles() {
        for (String extension : TEXT_EXTENSIONS) {
            String mimetype = Utils.getMimeType((File)new File('.' + extension));
            Assert.assertThat((Object)mimetype, (Matcher)Is.is((Object)TEXT_MIMETYPE));
        }
    }

    @Test
    public void shouldHaveCorrectMimetypeForEclipseXmlFiles() {
        for (String extension : XML_EXTENSIONS) {
            String mimetype = Utils.getMimeType((File)new File('.' + extension));
            Assert.assertThat((Object)mimetype, (Matcher)Is.is((Object)XML_MIMETYPE));
        }
    }

    @Test
    public void shouldUseDefaultMimetypeIfUnknownExtension() {
        String mimetype = Utils.getMimeType((File)new File(".bogusExtension"));
        Assert.assertThat((Object)mimetype, (Matcher)Is.is((Object)DEFAULT_MIMETYPE));
    }

    @Test
    public void shouldBeEquivalentIfBothObjectsAreNull() {
        Assert.assertThat((Object)Utils.equivalent(null, null), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBeEquivalentIfObjectsAreEqual() {
        String object = "object";
        Assert.assertThat((Object)Utils.equivalent((Object)object, (Object)object), (Matcher)Is.is((Object)true));
        String object2 = new String(object);
        Assert.assertThat((Object)Utils.equivalent((Object)object, (Object)object2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBeEquivalentIfOnlyOneObjectIsNull() {
        Assert.assertThat((Object)Utils.equivalent((Object)new Object(), null), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)Utils.equivalent(null, (Object)new Object()), (Matcher)Is.is((Object)false));
    }
}

