/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.nodetype.NodeType;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.NodeTypeNode;

public class NodeTypeNodeTest {
    private NodeTypeNode factory;
    private Repository repository;
    private Workspace workspace;
    private boolean print;

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        Server server = new Server("file:/tmp/temp.txt/resources", "user", "pswd");
        this.repository = new Repository("repo", server);
        this.workspace = new Workspace("myWorkspace", this.repository);
        this.factory = new NodeTypeNode(this.workspace);
    }

    @Test
    public void shouldParseJSONResponseContainingNodeTypes() throws Exception {
        String response = IoUtil.read((File)new File("src/test/resources/jcr_nodeTypes.txt"));
        Map nodeTypes = this.factory.getNodeTypes(response);
        this.printNodeTypes(nodeTypes);
    }

    protected void printNodeTypes(Map<String, NodeType> nodeTypes) {
        if (!this.print) {
            return;
        }
        LinkedList<NodeType> types = new LinkedList<NodeType>(nodeTypes.values());
        Collections.sort(types, new Comparator<NodeType>(){

            @Override
            public int compare(NodeType o1, NodeType o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1.startsWith("jcr:")) {
                    return -1;
                }
                if (name2.startsWith("jcr:")) {
                    return 1;
                }
                if (name1.startsWith("mix:")) {
                    return -1;
                }
                if (name2.startsWith("mix:")) {
                    return 1;
                }
                if (name1.startsWith("nt:")) {
                    return -1;
                }
                if (name2.startsWith("nt:")) {
                    return 1;
                }
                if (name1.startsWith("mode:")) {
                    return -1;
                }
                if (name2.startsWith("mode:")) {
                    return 1;
                }
                if (name1.startsWith("modeint:")) {
                    return -1;
                }
                if (name2.startsWith("modeint:")) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.printNodeTypes(types);
    }

    protected void printNodeTypes(Iterable<NodeType> nodeTypes) {
        if (this.print) {
            for (NodeType nodeType : nodeTypes) {
                System.out.println(nodeType);
            }
        }
    }
}

