/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.nodetype.NodeType;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.NodeTypeNode;

public class NodeTypeNodeTest {
    private NodeTypeNode factory;
    private Repository repository;
    private Workspace workspace;
    private boolean print;

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        Server server = new Server("file:/tmp/temp.txt/resources", "user", "pswd");
        this.repository = new Repository("repo", server);
        this.workspace = new Workspace("myWorkspace", this.repository);
        this.factory = new NodeTypeNode(this.workspace);
    }

    @Test
    public void shouldParseJSONResponseContainingOldNodeTypes() throws Exception {
        String response = IoUtil.read((File)new File("src/test/resources/jcr_nodeTypes.txt"));
        Map nodeTypes = this.factory.getNodeTypes(response);
        this.printNodeTypes(nodeTypes);
        this.verifyNodeTypes(nodeTypes);
    }

    @Test
    public void shouldParseJSONResponseContainingNewNodeTypes() throws Exception {
        String response = IoUtil.read((File)new File("src/test/resources/jcr_nodeTypes_new.txt"));
        Map nodeTypes = this.factory.getNodeTypes(response);
        this.printNodeTypes(nodeTypes);
        this.verifyNodeTypes(nodeTypes);
    }

    protected void verifyNodeTypes(Map<String, NodeType> nodeTypes) {
        NodeType created = nodeTypes.get("mix:created");
        Assert.assertThat((Object)created.getPropertyDefinitions().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)created.getChildNodeDefinitions().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)created.getPropertyDefinitions()[0].getName(), (Matcher)Is.is((Object)"jcr:created"));
        Assert.assertThat((Object)created.getPropertyDefinitions()[1].getName(), (Matcher)Is.is((Object)"jcr:createdBy"));
        NodeType nodeType = nodeTypes.get("nt:nodeType");
        Assert.assertThat((Object)nodeType.getPropertyDefinitions().length, (Matcher)Is.is((Object)9));
        Assert.assertThat((Object)nodeType.getChildNodeDefinitions().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[0].getName(), (Matcher)Is.is((Object)"jcr:nodeTypeName"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[1].getName(), (Matcher)Is.is((Object)"jcr:isAbstract"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[2].getName(), (Matcher)Is.is((Object)"jcr:isMixin"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[3].getName(), (Matcher)Is.is((Object)"jcr:supertypes"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[4].getName(), (Matcher)Is.is((Object)"jcr:primaryItemName"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[5].getName(), (Matcher)Is.is((Object)"jcr:hasOrderableChildNodes"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[6].getName(), (Matcher)Is.is((Object)"jcr:primaryType"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[7].getName(), (Matcher)Is.is((Object)"jcr:mixinTypes"));
        Assert.assertThat((Object)nodeType.getPropertyDefinitions()[8].getName(), (Matcher)Is.is((Object)"jcr:isQueryable"));
        Assert.assertThat((Object)nodeType.getChildNodeDefinitions()[0].getName(), (Matcher)Is.is((Object)"jcr:childNodeDefinition"));
        Assert.assertThat((Object)nodeType.getChildNodeDefinitions()[1].getName(), (Matcher)Is.is((Object)"jcr:propertyDefinition"));
    }

    protected void printNodeTypes(Map<String, NodeType> nodeTypes) {
        if (!this.print) {
            return;
        }
        LinkedList<NodeType> types = new LinkedList<NodeType>(nodeTypes.values());
        Collections.sort(types, new Comparator<NodeType>(){

            @Override
            public int compare(NodeType o1, NodeType o2) {
                String name2;
                String name1 = o1.getName();
                if (name1.equals(name2 = o2.getName())) {
                    return 0;
                }
                if (name1.startsWith("jcr:")) {
                    return name2.startsWith("jcr:") ? name1.compareTo(name2) : -1;
                }
                if (name2.startsWith("jcr:")) {
                    return 1;
                }
                if (name1.startsWith("mix:")) {
                    return name2.startsWith("mix:") ? name1.compareTo(name2) : -1;
                }
                if (name2.startsWith("mix:")) {
                    return 1;
                }
                if (name1.startsWith("nt:")) {
                    return name2.startsWith("nt:") ? name1.compareTo(name2) : -1;
                }
                if (name2.startsWith("nt:")) {
                    return 1;
                }
                if (name1.startsWith("mode:")) {
                    return name2.startsWith("mode:") ? name1.compareTo(name2) : -1;
                }
                if (name2.startsWith("mode:")) {
                    return 1;
                }
                if (name1.startsWith("modeint:")) {
                    return name2.startsWith("modeint:") ? name1.compareTo(name2) : -1;
                }
                if (name2.startsWith("modeint:")) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        this.printNodeTypes(types);
    }

    protected void printNodeTypes(Iterable<NodeType> nodeTypes) {
        if (this.print) {
            for (NodeType nodeType : nodeTypes) {
                System.out.println(nodeType);
            }
        }
    }
}

