/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import net.jcip.annotations.Immutable;
import org.modeshape.web.jcr.rest.AbstractJcrResource;
import org.modeshape.web.jcr.rest.model.WorkspaceEntry;

@Immutable
@Path(value="/")
public class RepositoryResource
extends AbstractJcrResource {
    @GET
    @Path(value="/{repositoryName}")
    @Produces(value={"application/json"})
    public Map<String, WorkspaceEntry> getWorkspaces(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName) throws RepositoryException, IOException {
        assert (request != null);
        assert (rawRepositoryName != null);
        HashMap<String, WorkspaceEntry> workspaces = new HashMap<String, WorkspaceEntry>();
        Session session = this.getSession(request, rawRepositoryName, null);
        rawRepositoryName = URL_ENCODER.encode(rawRepositoryName);
        for (String name : session.getWorkspace().getAccessibleWorkspaceNames()) {
            if (name.trim().length() == 0) {
                name = "<default>";
            }
            name = URL_ENCODER.encode(name);
            workspaces.put(name, new WorkspaceEntry(request.getContextPath(), rawRepositoryName, name));
        }
        return workspaces;
    }
}

