/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.collection.Collections;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.modeshape.web.jcr.rest.model.RestProperty;

public final class RestNode
extends RestItem {
    public static final String SELF_FIELD_NAME = "self";
    public static final String UP_FIELD_NAME = "up";
    public static final String ID_FIELD_NAME = "id";
    public static final String CHILDREN_FIELD_NAME = "children";
    private static final Set<String> RESERVED_FIELD_NAMES = Collections.unmodifiableSet((Object[])new String[]{"self", "up", "id", "children"});
    private final List<RestProperty> jcrProperties;
    private final List<RestNode> children;
    private final Map<String, String> customProperties;
    protected final String id;

    public RestNode(String name, String id, String url, String parentUrl) {
        super(name, url, parentUrl);
        this.id = id;
        this.jcrProperties = new ArrayList<RestProperty>();
        this.children = new ArrayList<RestNode>();
        this.customProperties = new TreeMap<String, String>();
    }

    public RestNode addChild(RestNode child) {
        this.children.add(child);
        return this;
    }

    public RestNode addJcrProperty(RestProperty property) {
        this.jcrProperties.add(property);
        return this;
    }

    public RestNode addCustomProperty(String name, String value) {
        this.customProperties.put(name, value);
        return this;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject node = new JSONObject();
        node.put(SELF_FIELD_NAME, (Object)this.url);
        node.put(UP_FIELD_NAME, (Object)this.parentUrl);
        node.put(ID_FIELD_NAME, (Object)this.id);
        this.addCustomProperties(node);
        this.addJcrProperties(node);
        this.addChildren(node);
        return node;
    }

    private boolean isReservedField(String fieldName) {
        return RESERVED_FIELD_NAMES.contains(fieldName);
    }

    private void addChildren(JSONObject node) throws JSONException {
        if (!this.children.isEmpty()) {
            JSONObject children = new JSONObject();
            for (RestNode child : this.children) {
                children.put(child.name, (Object)child.toJSON());
            }
            node.put(CHILDREN_FIELD_NAME, (Object)children);
        }
    }

    private void addJcrProperties(JSONObject node) throws JSONException {
        for (RestProperty restProperty : this.jcrProperties) {
            if (this.isReservedField(restProperty.name)) continue;
            if (restProperty.isMultiValue()) {
                node.put(restProperty.name, restProperty.getValues());
                continue;
            }
            if (restProperty.getValue() == null) continue;
            node.put(restProperty.name, (Object)restProperty.getValue());
        }
    }

    private void addCustomProperties(JSONObject node) throws JSONException {
        for (String customPropertyName : this.customProperties.keySet()) {
            if (this.isReservedField(customPropertyName)) continue;
            node.put(customPropertyName, (Object)this.customProperties.get(customPropertyName));
        }
    }
}

