/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.mime4j.field.ContentDispositionField;
import org.apache.james.mime4j.field.ContentTransferEncodingField;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyCopier;
import org.apache.james.mime4j.message.Disposable;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.Message;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.TextBody;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.MimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity
implements Disposable {
    private Header header = null;
    private Body body = null;
    private Entity parent = null;

    protected Entity() {
    }

    protected Entity(Entity other) {
        if (other.header != null) {
            this.header = new Header(other.header);
        }
        if (other.body != null) {
            Body bodyCopy = BodyCopier.copy(other.body);
            this.setBody(bodyCopy);
        }
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        if (this.body != null) {
            throw new IllegalStateException("body already set");
        }
        this.body = body;
        body.setParent(this);
    }

    public Body removeBody() {
        if (this.body == null) {
            return null;
        }
        Body body = this.body;
        this.body = null;
        body.setParent(null);
        return body;
    }

    public void setMessage(Message message) {
        this.setBody(message, "message/rfc822", null);
    }

    public void setMultipart(Multipart multipart) {
        String mimeType = "multipart/" + multipart.getSubType();
        Map<String, String> parameters = Collections.singletonMap("boundary", MimeUtil.createUniqueBoundary());
        this.setBody(multipart, mimeType, parameters);
    }

    public void setMultipart(Multipart multipart, Map<String, String> parameters) {
        String mimeType = "multipart/" + multipart.getSubType();
        if (!parameters.containsKey("boundary")) {
            parameters = new HashMap<String, String>(parameters);
            parameters.put("boundary", MimeUtil.createUniqueBoundary());
        }
        this.setBody(multipart, mimeType, parameters);
    }

    public void setText(TextBody textBody) {
        this.setText(textBody, "plain");
    }

    public void setText(TextBody textBody, String subtype) {
        String mimeType = "text/" + subtype;
        Map<String, String> parameters = null;
        String mimeCharset = textBody.getMimeCharset();
        if (mimeCharset != null && !mimeCharset.equalsIgnoreCase("us-ascii")) {
            parameters = Collections.singletonMap("charset", mimeCharset);
        }
        this.setBody(textBody, mimeType, parameters);
    }

    public void setBody(Body body, String mimeType) {
        this.setBody(body, mimeType, null);
    }

    public void setBody(Body body, String mimeType, Map<String, String> parameters) {
        this.setBody(body);
        Header header = this.obtainHeader();
        header.setField(Fields.contentType(mimeType, parameters));
    }

    public String getMimeType() {
        ContentTypeField child = (ContentTypeField)this.getHeader().getField("Content-Type");
        ContentTypeField parent = this.getParent() != null ? (ContentTypeField)this.getParent().getHeader().getField("Content-Type") : null;
        return ContentTypeField.getMimeType(child, parent);
    }

    public String getCharset() {
        return ContentTypeField.getCharset((ContentTypeField)this.getHeader().getField("Content-Type"));
    }

    public String getContentTransferEncoding() {
        ContentTransferEncodingField f = (ContentTransferEncodingField)this.getHeader().getField("Content-Transfer-Encoding");
        return ContentTransferEncodingField.getEncoding(f);
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        Header header = this.obtainHeader();
        header.setField(Fields.contentTransferEncoding(contentTransferEncoding));
    }

    public String getDispositionType() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        if (field == null) {
            return null;
        }
        return field.getDispositionType();
    }

    public void setContentDisposition(String dispositionType) {
        Header header = this.obtainHeader();
        header.setField(Fields.contentDisposition(dispositionType, null, -1L, null, null, null));
    }

    public void setContentDisposition(String dispositionType, String filename) {
        Header header = this.obtainHeader();
        header.setField(Fields.contentDisposition(dispositionType, filename, -1L, null, null, null));
    }

    public void setContentDisposition(String dispositionType, String filename, long size) {
        Header header = this.obtainHeader();
        header.setField(Fields.contentDisposition(dispositionType, filename, size, null, null, null));
    }

    public void setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
        Header header = this.obtainHeader();
        header.setField(Fields.contentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate));
    }

    public String getFilename() {
        ContentDispositionField field = (ContentDispositionField)this.obtainField("Content-Disposition");
        if (field == null) {
            return null;
        }
        return field.getFilename();
    }

    public void setFilename(String filename) {
        Header header = this.obtainHeader();
        ContentDispositionField field = (ContentDispositionField)header.getField("Content-Disposition");
        if (field == null) {
            if (filename != null) {
                header.setField(Fields.contentDisposition("attachment", filename, -1L, null, null, null));
            }
        } else {
            String dispositionType = field.getDispositionType();
            HashMap<String, String> parameters = new HashMap<String, String>(field.getParameters());
            if (filename == null) {
                parameters.remove("filename");
            } else {
                parameters.put("filename", filename);
            }
            header.setField(Fields.contentDisposition(dispositionType, parameters));
        }
    }

    public boolean isMimeType(String type) {
        return this.getMimeType().equalsIgnoreCase(type);
    }

    public boolean isMultipart() {
        ContentTypeField f = (ContentTypeField)this.getHeader().getField("Content-Type");
        return f != null && f.getBoundary() != null && this.getMimeType().startsWith("multipart/");
    }

    @Override
    public void dispose() {
        if (this.body != null) {
            this.body.dispose();
        }
    }

    Header obtainHeader() {
        if (this.header == null) {
            this.header = new Header();
        }
        return this.header;
    }

    <F extends Field> F obtainField(String fieldName) {
        Header header = this.getHeader();
        if (header == null) {
            return null;
        }
        Field field = header.getField(fieldName);
        return (F)field;
    }
}

