/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.model.JSONAble;

public final class RestRepositories
implements JSONAble {
    private final List<Repository> repositories = new ArrayList<Repository>();

    public Repository addRepository(String name, String url) {
        Repository repository = new Repository(name, url);
        this.repositories.add(repository);
        return repository;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray repositories = new JSONArray();
        for (Repository repository : this.repositories) {
            repositories.put((Object)repository.toJSON());
        }
        result.put("repositories", (Object)repositories);
        return result;
    }

    public final class Repository
    implements JSONAble {
        private final String name;
        private final String url;
        private final Map<String, List<String>> metadata;
        private int activeSessionsCount;

        protected Repository(String name, String url) {
            this.name = name;
            this.url = url;
            this.metadata = new TreeMap<String, List<String>>();
        }

        public void addMetadata(String key, List<String> value) {
            if (key != null && value != null && !value.isEmpty()) {
                this.metadata.put(key, value);
            }
        }

        public void setActiveSessionsCount(int activeSessionsCount) {
            this.activeSessionsCount = activeSessionsCount;
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject object = new JSONObject();
            object.put("name", (Object)this.name);
            object.put("workspaces", (Object)this.url);
            object.put("activeSessionsCount", this.activeSessionsCount);
            JSONObject metadata = new JSONObject();
            for (String metadataKey : this.metadata.keySet()) {
                List<String> values = this.metadata.get(metadataKey);
                if (values.size() == 1) {
                    metadata.put(metadataKey, (Object)values.get(0));
                    continue;
                }
                metadata.put(metadataKey, values);
            }
            object.put("metadata", (Object)metadata);
            return object;
        }
    }
}

