/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.modeshape.jcr.api.Logger;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.WebLogger;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.model.RestException;

@Provider
public class ModeShapeExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = WebLogger.getLogger(ModeShapeExceptionMapper.class);

    public Response toResponse(Throwable throwable) {
        AbstractHandler.cleanupActiveSession();
        if (throwable instanceof NotFoundException || throwable instanceof PathNotFoundException || throwable instanceof NoSuchWorkspaceException || throwable instanceof NoSuchRepositoryException || throwable instanceof NoSuchNodeTypeException) {
            return this.exceptionResponse(throwable, Response.Status.NOT_FOUND);
        }
        if (throwable instanceof NotAuthorizedException) {
            return this.exceptionResponse(throwable, Response.Status.FORBIDDEN);
        }
        if (throwable instanceof JSONException || throwable instanceof InvalidQueryException || throwable instanceof RepositoryException || throwable instanceof IllegalArgumentException) {
            return this.exceptionResponse(throwable, Response.Status.BAD_REQUEST);
        }
        return this.exceptionResponse(throwable, Response.Status.INTERNAL_SERVER_ERROR);
    }

    private Response exceptionResponse(Throwable t, Response.Status status) {
        switch (status) {
            case NOT_FOUND: {
                LOGGER.debug(t, "Item not found", new Object[0]);
                break;
            }
            default: {
                LOGGER.error(t, "Server error", new Object[0]);
            }
        }
        return Response.status((Response.Status)status).entity((Object)new RestException(t)).build();
    }
}

