/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.BackupOptions;
import org.modeshape.jcr.api.RestoreOptions;
import org.modeshape.web.jcr.rest.form.FileUploadForm;
import org.modeshape.web.jcr.rest.handler.RestBinaryHandler;
import org.modeshape.web.jcr.rest.handler.RestItemHandler;
import org.modeshape.web.jcr.rest.handler.RestNodeHandler;
import org.modeshape.web.jcr.rest.handler.RestNodeTypeHandler;
import org.modeshape.web.jcr.rest.handler.RestQueryHandler;
import org.modeshape.web.jcr.rest.handler.RestRepositoryHandler;
import org.modeshape.web.jcr.rest.handler.RestServerHandler;
import org.modeshape.web.jcr.rest.model.RestException;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.modeshape.web.jcr.rest.model.RestNodeType;
import org.modeshape.web.jcr.rest.model.RestQueryPlanResult;
import org.modeshape.web.jcr.rest.model.RestQueryResult;
import org.modeshape.web.jcr.rest.model.RestRepositories;
import org.modeshape.web.jcr.rest.model.RestWorkspaces;

@Immutable
@Path(value="/")
public final class ModeShapeRestService {
    private RestServerHandler serverHandler = new RestServerHandler();
    private RestRepositoryHandler repositoryHandler = new RestRepositoryHandler();
    private RestItemHandler itemHandler = new RestItemHandler();
    private RestNodeHandler nodeHandler = new RestNodeHandler();
    private RestQueryHandler queryHandler = new RestQueryHandler();
    private RestBinaryHandler binaryHandler = new RestBinaryHandler();
    private RestNodeTypeHandler nodeTypeHandler = new RestNodeTypeHandler();

    @GET
    @Path(value="/")
    @Produces(value={"text/html", "text/plain", "application/json"})
    public RestRepositories getRepositories(@Context HttpServletRequest request) {
        return this.serverHandler.getRepositories(request);
    }

    @GET
    @Path(value="{repositoryName}")
    @Produces(value={"text/html", "text/plain", "application/json"})
    public RestWorkspaces getWorkspaces(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName) throws RepositoryException {
        return this.repositoryHandler.getWorkspaces(request, rawRepositoryName);
    }

    @POST
    @Path(value="{repositoryName}/backup")
    @Produces(value={"application/json", "text/html", "text/plain"})
    public Response backup(@Context ServletContext servletContext, @Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, final @QueryParam(value="includeBinaries") @DefaultValue(value="true") boolean includeBinaries, final @QueryParam(value="documentsPerFile") @DefaultValue(value="100000") long documentsPerFile, final @QueryParam(value="compress") @DefaultValue(value="true") boolean compress) throws RepositoryException {
        return this.repositoryHandler.backupRepository(servletContext, request, repositoryName, new BackupOptions(){

            public boolean includeBinaries() {
                return includeBinaries;
            }

            public long documentsPerFile() {
                return documentsPerFile;
            }

            public boolean compress() {
                return compress;
            }
        });
    }

    @POST
    @Path(value="{repositoryName}/restore")
    @Produces(value={"application/json", "text/html", "text/plain"})
    public Response restore(@Context ServletContext servletContext, @Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @QueryParam(value="name") String backupName, final @QueryParam(value="includeBinaries") @DefaultValue(value="true") boolean includeBinaries, final @QueryParam(value="reindexContent") @DefaultValue(value="true") boolean reindexContent) throws RepositoryException {
        return this.repositoryHandler.restoreRepository(servletContext, request, repositoryName, backupName, new RestoreOptions(){

            public boolean reindexContentOnFinish() {
                return reindexContent;
            }

            public boolean includeBinaries() {
                return includeBinaries;
            }
        });
    }

    @GET
    @Path(value="{repositoryName}/{workspaceName}/binary{path:.+}")
    @Produces(value={"text/html", "text/plain", "application/json"})
    public Response getBinary(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="path") String path, @QueryParam(value="mimeType") String mimeType, @QueryParam(value="contentDisposition") String contentDisposition) throws RepositoryException {
        Property binaryProperty = this.binaryHandler.getBinaryProperty(request, repositoryName, workspaceName, path);
        if (binaryProperty.getType() != 2) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestException("The property " + binaryProperty.getPath() + " is not a binary")).build();
        }
        Binary binary = binaryProperty.getBinary();
        if (StringUtil.isBlank((String)mimeType)) {
            mimeType = this.binaryHandler.getDefaultMimeType(binaryProperty);
        }
        if (StringUtil.isBlank((String)contentDisposition)) {
            contentDisposition = this.binaryHandler.getDefaultContentDisposition(binaryProperty);
        }
        return Response.ok((Object)binary.getStream(), (String)mimeType).header("Content-Disposition", (Object)contentDisposition).build();
    }

    @GET
    @Path(value="{repositoryName}/{workspaceName}/nodetypes/{nodeTypeName:.+}")
    @Produces(value={"text/html", "text/plain", "application/json"})
    public RestNodeType getNodeType(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodeTypeName") String nodeTypeName) throws RepositoryException {
        return this.nodeTypeHandler.getNodeType(request, repositoryName, workspaceName, nodeTypeName);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/nodetypes")
    @Produces(value={"application/json", "text/html", "text/plain"})
    public Response postCND(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @QueryParam(value="allowUpdate") @DefaultValue(value="true") boolean allowUpdate, InputStream requestBodyInputStream) throws RepositoryException {
        return this.nodeTypeHandler.importCND(request, repositoryName, workspaceName, allowUpdate, requestBodyInputStream);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/nodetypes")
    @Produces(value={"text/html", "application/json", "text/plain"})
    @Consumes(value={"multipart/form-data"})
    public Response postCNDViaForm(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @QueryParam(value="allowUpdate") @DefaultValue(value="true") boolean allowUpdate, @MultipartForm FileUploadForm form) throws RepositoryException {
        form.validate();
        return this.nodeTypeHandler.importCND(request, repositoryName, workspaceName, allowUpdate, form.getFileData());
    }

    @GET
    @Path(value="{repositoryName}/{workspaceName}/items{path:.*}")
    @Produces(value={"text/html", "text/plain", "application/json"})
    public RestItem getItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, @QueryParam(value="depth") @DefaultValue(value="0") int depth) throws RepositoryException {
        return this.itemHandler.item(request, rawRepositoryName, rawWorkspaceName, path, depth);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{repositoryName}/{workspaceName}/items{path:.+}")
    @Produces(value={"application/json", "text/plain", "text/html"})
    public Response postItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws RepositoryException, JSONException {
        return this.itemHandler.addItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{repositoryName}/{workspaceName}/items")
    @Produces(value={"application/json", "text/plain", "text/html"})
    public Response postItems(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, String requestContent) throws RepositoryException, JSONException {
        return this.itemHandler.addItems(request, rawRepositoryName, rawWorkspaceName, requestContent);
    }

    @DELETE
    @Path(value="{repositoryName}/{workspaceName}/items{path:.+}")
    public Response deleteItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path) throws RepositoryException {
        this.itemHandler.deleteItem(request, rawRepositoryName, rawWorkspaceName, path);
        return Response.noContent().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="{repositoryName}/{workspaceName}/items")
    public Response deleteItems(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, String requestContent) throws RepositoryException, JSONException {
        return this.itemHandler.deleteItems(request, rawRepositoryName, rawWorkspaceName, requestContent);
    }

    @PUT
    @Path(value="{repositoryName}/{workspaceName}/items{path:.+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestItem putItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws JSONException, RepositoryException {
        return this.itemHandler.updateItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
    }

    @PUT
    @Path(value="{repositoryName}/{workspaceName}/items")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public Response putItems(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, String requestContent) throws JSONException, RepositoryException {
        return this.itemHandler.updateItems(request, rawRepositoryName, rawWorkspaceName, requestContent);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/binary{path:.+}")
    @Produces(value={"application/json", "text/html", "text/plain"})
    public Response postBinary(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="path") String path, InputStream requestBodyInputStream) throws RepositoryException {
        return this.binaryHandler.updateBinary(request, repositoryName, workspaceName, path, requestBodyInputStream, true);
    }

    @PUT
    @Path(value="{repositoryName}/{workspaceName}/binary{path:.+}")
    @Produces(value={"application/json", "text/html", "text/plain"})
    public Response putBinary(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="path") String path, InputStream requestBodyInputStream) throws RepositoryException {
        return this.binaryHandler.updateBinary(request, repositoryName, workspaceName, path, requestBodyInputStream, false);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/binary{path:.+}")
    @Produces(value={"text/html", "application/json", "text/plain"})
    @Consumes(value={"multipart/form-data"})
    public Response postBinaryViaForm(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="path") String path, @MultipartForm FileUploadForm form) throws RepositoryException {
        form.validate();
        return this.binaryHandler.updateBinary(request, repositoryName, workspaceName, path, form.getFileData(), true);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/upload{path:.+}")
    @Produces(value={"text/html", "application/json", "text/plain"})
    @Consumes(value={"multipart/form-data"})
    public Response uploadBinaryViaForm(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="path") String filePath, @MultipartForm FileUploadForm form) throws RepositoryException {
        form.validate();
        return this.binaryHandler.uploadBinary(request, repositoryName, workspaceName, filePath, form.getFileData());
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/upload{path:.+}")
    @Produces(value={"text/html", "application/json", "text/plain"})
    public Response uploadBinary(@Context HttpServletRequest request, @PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="path") String filePath, InputStream requestBodyInputStream) throws RepositoryException {
        return this.binaryHandler.uploadBinary(request, repositoryName, workspaceName, filePath, requestBodyInputStream);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+xpath"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryResult postXPathQuery(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.executeQuery(request, rawRepositoryName, rawWorkspaceName, "xpath", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+sql"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryResult postJcrSqlQuery(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.executeQuery(request, rawRepositoryName, rawWorkspaceName, "sql", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+sql2"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryResult postJcrSql2Query(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.executeQuery(request, rawRepositoryName, rawWorkspaceName, "JCR-SQL2", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+search"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryResult postJcrSearchQuery(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.executeQuery(request, rawRepositoryName, rawWorkspaceName, "search", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/queryPlan")
    @Consumes(value={"application/jcr+xpath"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryPlanResult postXPathQueryPlan(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.planQuery(request, rawRepositoryName, rawWorkspaceName, "xpath", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/queryPlan")
    @Consumes(value={"application/jcr+sql"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryPlanResult postJcrSqlQueryPlan(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.planQuery(request, rawRepositoryName, rawWorkspaceName, "sql", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/queryPlan")
    @Consumes(value={"application/jcr+sql2"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestQueryPlanResult postJcrSql2QueryPlan(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.planQuery(request, rawRepositoryName, rawWorkspaceName, "JCR-SQL2", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/queryPlan")
    @Consumes(value={"application/jcr+search"})
    @Produces(value={"text/plain", "application/json", "text/html"})
    public RestQueryPlanResult postJcrSearchQueryPlan(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException {
        return this.queryHandler.planQuery(request, rawRepositoryName, rawWorkspaceName, "search", requestContent, offset, limit, uriInfo);
    }

    @GET
    @Path(value="{repositoryName}/{workspaceName}/nodes/{id:.*}")
    @Produces(value={"text/html", "text/plain", "application/json"})
    public RestItem getNodeWithId(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="id") String id, @QueryParam(value="depth") @DefaultValue(value="0") int depth) throws RepositoryException {
        return this.nodeHandler.nodeWithId(request, rawRepositoryName, rawWorkspaceName, id, depth);
    }

    @PUT
    @Path(value="{repositoryName}/{workspaceName}/nodes/{id:.+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain"})
    public RestItem putNodeWithId(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="id") String id, String requestContent) throws JSONException, RepositoryException {
        return this.nodeHandler.updateNodeWithId(request, rawRepositoryName, rawWorkspaceName, id, requestContent);
    }

    @DELETE
    @Path(value="{repositoryName}/{workspaceName}/nodes/{id:.+}")
    public Response deleteNodeWithId(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="id") String id) throws RepositoryException {
        this.nodeHandler.deleteNodeWithId(request, rawRepositoryName, rawWorkspaceName, id);
        return Response.noContent().build();
    }
}

