/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.model.RestQueryPlanResult;
import org.modeshape.web.jcr.rest.model.RestQueryResult;

public final class RestQueryHandler
extends AbstractHandler {
    private static final String MODE_URI = "mode:uri";
    private static final String UNKNOWN_TYPE = "unknown-type";
    private static final List<String> SKIP_QUERY_PARAMETERS = Arrays.asList("offset", "limit");

    public RestQueryResult executeQuery(HttpServletRequest request, String repositoryName, String workspaceName, String language, String statement, long offset, long limit, UriInfo uriInfo) throws RepositoryException {
        assert (repositoryName != null);
        assert (workspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, repositoryName, workspaceName);
        org.modeshape.jcr.api.query.Query query = this.createQuery(language, statement, session);
        this.bindExtraVariables(uriInfo, session.getValueFactory(), (Query)query);
        javax.jcr.query.QueryResult result = query.execute();
        RestQueryResult restQueryResult = new RestQueryResult();
        String[] columnNames = result.getColumnNames();
        this.setColumns(result, restQueryResult, columnNames);
        String baseUrl = RestHelper.repositoryUrl(request);
        this.setRows(offset, limit, session, result, restQueryResult, columnNames, baseUrl);
        return restQueryResult;
    }

    public RestQueryPlanResult planQuery(HttpServletRequest request, String repositoryName, String workspaceName, String language, String statement, long offset, long limit, UriInfo uriInfo) throws RepositoryException {
        assert (repositoryName != null);
        assert (workspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, repositoryName, workspaceName);
        org.modeshape.jcr.api.query.Query query = this.createQuery(language, statement, session);
        this.bindExtraVariables(uriInfo, session.getValueFactory(), (Query)query);
        QueryResult result = query.explain();
        String plan = result.getPlan();
        return new RestQueryPlanResult(plan, statement, language, query.getAbstractQueryModelRepresentation());
    }

    private void setRows(long offset, long limit, Session session, javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames, String baseUrl) throws RepositoryException {
        RowIterator resultRows = result.getRows();
        if (offset > 0L) {
            resultRows.skip(offset);
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        while (resultRows.hasNext() && limit > 0L) {
            --limit;
            Row resultRow = resultRows.nextRow();
            RestQueryResult.RestRow restRow = this.createRestRow(session, result, restQueryResult, columnNames, baseUrl, resultRow);
            this.createLinksFromNodePaths(result, baseUrl, resultRow, restRow);
            restQueryResult.addRow(restRow);
        }
    }

    private void createLinksFromNodePaths(javax.jcr.query.QueryResult result, String baseUrl, Row resultRow, RestQueryResult.RestRow restRow) throws RepositoryException {
        if (result.getSelectorNames().length == 1) {
            String defaultPath = this.encodedPath(resultRow.getPath());
            if (!StringUtil.isBlank((String)defaultPath)) {
                restRow.addValue(MODE_URI, RestHelper.urlFrom(baseUrl, "items", defaultPath));
            }
        } else {
            for (String selectorName : result.getSelectorNames()) {
                try {
                    String selectorPath = this.encodedPath(resultRow.getPath(selectorName));
                    restRow.addValue("mode:uri-" + selectorName, RestHelper.urlFrom(baseUrl, "items", selectorPath));
                }
                catch (RepositoryException e) {
                    this.logger.debug((Throwable)e, e.getMessage(), new Object[0]);
                }
            }
        }
    }

    private RestQueryResult.RestRow createRestRow(Session session, javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames, String baseUrl, Row resultRow) throws RepositoryException {
        RestQueryResult.RestRow restRow = restQueryResult.new RestQueryResult.RestRow();
        Map<Value, String> binaryPropertyPaths = null;
        for (String columnName : columnNames) {
            Value value = resultRow.getValue(columnName);
            if (value == null) continue;
            String propertyPath = null;
            if (value.getType() == 2) {
                if (binaryPropertyPaths == null) {
                    binaryPropertyPaths = this.binaryPropertyPaths(resultRow, result.getSelectorNames());
                }
                propertyPath = (String)binaryPropertyPaths.get(value);
            }
            String valueString = this.valueToString(propertyPath, value, baseUrl, session);
            restRow.addValue(columnName, valueString);
        }
        return restRow;
    }

    private Map<Value, String> binaryPropertyPaths(Row row, String[] selectorNames) throws RepositoryException {
        HashMap<Value, String> result = new HashMap<Value, String>();
        Node node = row.getNode();
        if (node != null) {
            result.putAll(this.binaryPropertyPaths(node));
        }
        for (String selectorName : selectorNames) {
            Node selectedNode = row.getNode(selectorName);
            if (selectedNode == null || selectedNode == node) continue;
            result.putAll(this.binaryPropertyPaths(selectedNode));
        }
        return result;
    }

    private Map<Value, String> binaryPropertyPaths(Node node) throws RepositoryException {
        HashMap<Value, String> result = new HashMap<Value, String>();
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (property.getType() != 2) continue;
            result.put(property.getValue(), property.getPath());
        }
        return result;
    }

    private void setColumns(javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames) {
        if (result instanceof QueryResult) {
            QueryResult modeShapeQueryResult = (QueryResult)result;
            String[] columnTypes = modeShapeQueryResult.getColumnTypes();
            for (int i = 0; i < columnNames.length; ++i) {
                restQueryResult.addColumn(columnNames[i], columnTypes[i]);
            }
        } else {
            for (String columnName : columnNames) {
                restQueryResult.addColumn(columnName, UNKNOWN_TYPE);
            }
        }
    }

    private org.modeshape.jcr.api.query.Query createQuery(String language, String statement, Session session) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (org.modeshape.jcr.api.query.Query)queryManager.createQuery(statement, language);
    }

    private void bindExtraVariables(UriInfo uriInfo, ValueFactory valueFactory, Query query) throws RepositoryException {
        if (uriInfo == null) {
            return;
        }
        for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            String variableName = (String)entry.getKey();
            List variableValues = (List)entry.getValue();
            if (variableValues == null || variableValues.isEmpty() || SKIP_QUERY_PARAMETERS.contains(variableName)) continue;
            Iterator valuesIterator = variableValues.iterator();
            String variableValue = null;
            while (valuesIterator.hasNext() && variableValue == null) {
                variableValue = (String)valuesIterator.next();
            }
            if (variableValue == null) continue;
            query.bindValue(variableName, valueFactory.createValue(variableValue));
        }
    }
}

