/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.handler.ItemHandler;
import org.modeshape.web.jcr.rest.model.RestItem;

public final class RestItemHandler
extends ItemHandler {
    public RestItem item(HttpServletRequest request, String repositoryName, String workspaceName, String path, int depth) throws RepositoryException {
        Session session = this.getSession(request, repositoryName, workspaceName);
        Item item = this.itemAtPath(path, session);
        return this.createRestItem(request, depth, session, item);
    }

    public Response addItem(HttpServletRequest request, String repositoryName, String workspaceName, String path, String requestBody) throws JSONException, RepositoryException {
        JSONObject requestBodyJSON = this.stringToJSONObject(requestBody);
        String parentAbsPath = this.parentPath(path);
        String newNodeName = this.newNodeName(path);
        Session session = this.getSession(request, repositoryName, workspaceName);
        Node parentNode = (Node)session.getItem(parentAbsPath);
        Node newNode = this.addNode(parentNode, newNodeName, requestBodyJSON);
        session.save();
        RestItem restNewNode = this.createRestItem(request, 0, session, (Item)newNode);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)restNewNode).build();
    }

    @Override
    protected JSONObject getProperties(JSONObject jsonNode) throws JSONException {
        JSONObject properties = new JSONObject();
        Iterator keysIterator = jsonNode.keys();
        while (keysIterator.hasNext()) {
            String key = keysIterator.next().toString();
            if ("children".equalsIgnoreCase(key)) continue;
            properties.put(key, jsonNode.get(key));
        }
        return properties;
    }

    private String newNodeName(String path) {
        int lastSlashInd = path.lastIndexOf(47);
        String name = lastSlashInd == -1 ? path : path.substring(lastSlashInd + 1);
        name = name.replaceAll("\\[\\d+\\]$", "");
        return name;
    }

    public RestItem updateItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String path, String requestContent) throws JSONException, RepositoryException {
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Item item = this.itemAtPath(path, session);
        item = this.updateItem(item, this.stringToJSONObject(requestContent));
        session.save();
        return this.createRestItem(request, 0, session, item);
    }

    private JSONObject stringToJSONObject(String requestBody) throws JSONException {
        return StringUtil.isBlank((String)requestBody) ? new JSONObject() : new JSONObject(requestBody);
    }

    private JSONArray stringToJSONArray(String requestBody) throws JSONException {
        return StringUtil.isBlank((String)requestBody) ? new JSONArray() : new JSONArray(requestBody);
    }

    public Response addItems(HttpServletRequest request, String repositoryName, String workspaceName, String requestContent) throws JSONException, RepositoryException {
        JSONObject requestBody = this.stringToJSONObject(requestContent);
        if (requestBody.length() == 0) {
            return Response.ok().build();
        }
        Session session = this.getSession(request, repositoryName, workspaceName);
        TreeMap<String, JSONObject> nodesByPath = this.createNodesByPathMap(requestBody);
        return this.addMultipleNodes(request, nodesByPath, session);
    }

    public Response updateItems(HttpServletRequest request, String repositoryName, String workspaceName, String requestContent) throws JSONException, RepositoryException {
        JSONObject requestBody = this.stringToJSONObject(requestContent);
        if (requestBody.length() == 0) {
            return Response.ok().build();
        }
        Session session = this.getSession(request, repositoryName, workspaceName);
        TreeMap<String, JSONObject> nodesByPath = this.createNodesByPathMap(requestBody);
        List<RestItem> result = this.updateMultipleNodes(request, session, nodesByPath);
        return this.createOkResponse(result);
    }

    public Response deleteItems(HttpServletRequest request, String repositoryName, String workspaceName, String requestContent) throws JSONException, RepositoryException {
        JSONArray requestArray = this.stringToJSONArray(requestContent);
        if (requestArray.length() == 0) {
            return Response.ok().build();
        }
        Session session = this.getSession(request, repositoryName, workspaceName);
        TreeSet<String> pathsInOrder = new TreeSet<String>();
        for (int i = 0; i < requestArray.length(); ++i) {
            pathsInOrder.add(this.absPath(requestArray.get(i).toString()));
        }
        ArrayList pathsInOrderList = new ArrayList(pathsInOrder);
        Collections.reverse(pathsInOrderList);
        for (String path : pathsInOrderList) {
            try {
                this.doDelete(path, session);
            }
            catch (NotFoundException e) {
                this.logger.info("Node at path {0} already deleted", new Object[]{path});
            }
        }
        session.save();
        return Response.ok().build();
    }

    private List<RestItem> updateMultipleNodes(HttpServletRequest request, Session session, TreeMap<String, JSONObject> nodesByPath) throws RepositoryException, JSONException {
        ArrayList<RestItem> result = new ArrayList<RestItem>();
        for (String nodePath : nodesByPath.keySet()) {
            Item item = session.getItem(nodePath);
            item = this.updateItem(item, nodesByPath.get(nodePath));
            result.add(this.createRestItem(request, 0, session, item));
        }
        session.save();
        return result;
    }

    private TreeMap<String, JSONObject> createNodesByPathMap(JSONObject requestBodyJSON) throws JSONException {
        TreeMap<String, JSONObject> nodesByPath = new TreeMap<String, JSONObject>();
        Iterator iterator = requestBodyJSON.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String nodePath = this.absPath(key);
            JSONObject nodeJSON = requestBodyJSON.getJSONObject(key);
            nodesByPath.put(nodePath, nodeJSON);
        }
        return nodesByPath;
    }

    private Response addMultipleNodes(HttpServletRequest request, TreeMap<String, JSONObject> nodesByPath, Session session) throws RepositoryException, JSONException {
        ArrayList<RestItem> result = new ArrayList<RestItem>();
        for (String nodePath : nodesByPath.keySet()) {
            String parentAbsPath = this.parentPath(nodePath);
            String newNodeName = this.newNodeName(nodePath);
            Node parentNode = (Node)session.getItem(parentAbsPath);
            Node newNode = this.addNode(parentNode, newNodeName, nodesByPath.get(nodePath));
            RestItem restNewNode = this.createRestItem(request, 0, session, (Item)newNode);
            result.add(restNewNode);
        }
        session.save();
        return this.createOkResponse(result);
    }

    private Response createOkResponse(List<RestItem> result) {
        GenericEntity<List<RestItem>> entity = new GenericEntity<List<RestItem>>(result){};
        return Response.ok().entity((Object)entity).build();
    }
}

