/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import com.googlecode.sardine.DavResource;
import com.googlecode.sardine.Sardine;
import com.googlecode.sardine.SardineFactory;
import com.googlecode.sardine.util.SardineException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;

public class ModeShapeWebdavStoreClientTest {
    private static final String REPOSITORY_NAME = "webdav_repo";
    private static final String SERVER_CONTEXT = "http://localhost:8090/webdav";
    private Sardine sardine;

    @Before
    public void beforeEach() throws Exception {
        this.sardine = this.initializeWebDavClient();
    }

    protected Sardine initializeWebDavClient() throws SardineException {
        return SardineFactory.begin((String)"dnauser", (String)"password");
    }

    @Test
    public void shouldNotConnectWithInvalidCredentials() throws Exception {
        this.sardine = SardineFactory.begin();
        Assert.assertFalse((boolean)this.sardine.exists(this.getServerUrl(null)));
    }

    @Test
    public void shouldConnectToRepository() throws Exception {
        String uri = this.getServerUrl(null);
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        Assert.assertNotNull((Object)this.sardine.getResources(uri));
    }

    @Test
    public void shouldConnectToRepositoryAndWorkspace() throws Exception {
        String uri = this.getServerUrl(this.getDefaultWorkspaceName());
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        Assert.assertNotNull((Object)this.sardine.getResources(uri));
    }

    @Test
    public void shouldNotFindInvalidRepository() throws Exception {
        String uri = this.getServerContext() + "/missing_repo";
        Assert.assertFalse((boolean)this.sardine.exists(uri));
    }

    @Test
    public void shouldNotFindInvalidWorkspace() throws Exception {
        String uri = this.getServerUrl("missingWS");
        Assert.assertFalse((boolean)this.sardine.exists(uri));
    }

    @Test
    public void shouldCreateFolder() throws Exception {
        String folderName = "testFolder" + UUID.randomUUID().toString();
        String uri = this.getServerUrl(this.getDefaultWorkspaceName()) + "/" + folderName;
        this.sardine.createDirectory(uri);
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        DavResource folder = this.getResourceAtURI(uri);
        Assert.assertEquals((long)0L, (long)folder.getContentLength());
    }

    private DavResource getResourceAtURI(String uri) throws SardineException {
        List resourcesList = this.sardine.getResources(uri);
        Assert.assertEquals((long)1L, (long)resourcesList.size());
        return (DavResource)resourcesList.get(0);
    }

    @Test
    public void shouldCreateFile() throws Exception {
        String folderUri = this.getServerUrl(this.getDefaultWorkspaceName()) + "/testDirectory" + UUID.randomUUID().toString();
        this.sardine.createDirectory(folderUri);
        InputStream fileStream = this.getClass().getClassLoader().getResourceAsStream("textfile.txt");
        Assert.assertNotNull((Object)fileStream);
        String fileUri = folderUri + "/testFile" + UUID.randomUUID().toString();
        this.sardine.put(fileUri, fileStream);
        Assert.assertTrue((boolean)this.sardine.exists(fileUri));
        DavResource file = this.getResourceAtURI(fileUri);
        byte[] fileBytes = IoUtil.readBytes((InputStream)this.getClass().getClassLoader().getResourceAsStream("textfile.txt"));
        Assert.assertEquals((long)fileBytes.length, (long)file.getContentLength());
    }

    private String getServerUrl(String workspaceName) {
        String serverContext = this.getServerContext();
        Assert.assertNotNull((Object)serverContext);
        String repositoryName = this.getRepositoryName();
        Assert.assertNotNull((Object)repositoryName);
        String baseUrl = serverContext + "/" + repositoryName;
        return workspaceName != null ? baseUrl + "/" + workspaceName : baseUrl;
    }

    protected String getDefaultWorkspaceName() {
        return "default";
    }

    protected String getServerContext() {
        return SERVER_CONTEXT;
    }

    protected String getRepositoryName() {
        return REPOSITORY_NAME;
    }
}

