/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.ObjectAlreadyExistsException;
import org.modeshape.webdav.exceptions.ObjectNotFoundException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.fromcatalina.RequestUtil;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.AbstractMethod;
import org.modeshape.webdav.methods.DeterminableMethod;
import org.modeshape.webdav.methods.DoDelete;

public class DoCopy
extends AbstractMethod {
    private static Logger LOG = Logger.getLogger(DoCopy.class);
    private final IWebdavStore store;
    private final ResourceLocks resourceLocks;
    private final DoDelete doDelete;
    private final boolean readOnly;

    public DoCopy(IWebdavStore store, ResourceLocks resourceLocks, DoDelete doDelete, boolean readOnly) {
        this.store = store;
        this.resourceLocks = resourceLocks;
        this.doDelete = doDelete;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName(), new Object[0]);
        String path = this.getRelativePath(req);
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String tempLockOwner = "doCopy" + System.currentTimeMillis() + req.toString();
        try {
            if (!this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                LOG.debug("Resource lock failed.", new Object[0]);
                resp.sendError(500);
                return;
            }
            this.copyResource(transaction, req, resp);
        }
        catch (AccessDeniedException e) {
            LOG.debug((Throwable)e, "Access denied for " + path, new Object[0]);
            resp.sendError(403);
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.debug((Throwable)e, "Conflict for " + path, new Object[0]);
            resp.sendError(409, req.getRequestURI());
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Throwable)e, "Not found for " + path, new Object[0]);
            resp.sendError(404, req.getRequestURI());
        }
        catch (WebdavException e) {
            LOG.debug((Throwable)e, "Error for " + path, new Object[0]);
            resp.sendError(500);
        }
        finally {
            this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean copyResource(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException, LockFailedException {
        String destinationPath = this.parseDestinationHeader(req, resp);
        if (destinationPath == null) {
            return false;
        }
        String path = this.getRelativePath(req);
        if (path.equals(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        String parentDestinationPath = this.getParentPath(this.getCleanPath(destinationPath));
        if (!this.isUnlocked(transaction, req, this.resourceLocks, parentDestinationPath)) {
            resp.setStatus(423);
            return false;
        }
        if (!this.isUnlocked(transaction, req, this.resourceLocks, destinationPath)) {
            resp.setStatus(423);
            return false;
        }
        boolean overwrite = this.shouldOverwrite(req);
        String lockOwner = "copyResource" + System.currentTimeMillis() + req.toString();
        if (this.resourceLocks.lock(transaction, destinationPath, lockOwner, false, 0, 10, true)) {
            StoredObject destinationSo = null;
            try {
                StoredObject copySo = this.store.getStoredObject(transaction, path);
                if (copySo == null) {
                    resp.sendError(404);
                    boolean bl = false;
                    return bl;
                }
                if (copySo.isNullResource()) {
                    String methodsAllowed = DeterminableMethod.determineMethodsAllowed(copySo);
                    resp.addHeader("Allow", methodsAllowed);
                    resp.sendError(405);
                    boolean bl = false;
                    return bl;
                }
                errorList = new Hashtable();
                destinationSo = this.store.getStoredObject(transaction, destinationPath);
                if (overwrite) {
                    if (destinationSo != null) {
                        this.doDelete.deleteResource(transaction, destinationPath, errorList, req, resp);
                    } else {
                        resp.setStatus(201);
                    }
                } else {
                    if (destinationSo != null) {
                        resp.sendError(412);
                        boolean bl = false;
                        return bl;
                    }
                    resp.setStatus(201);
                }
                this.copy(transaction, path, destinationPath, errorList, req, resp);
                if (errorList.isEmpty()) return true;
                this.sendReport(req, resp, errorList);
                return true;
            }
            finally {
                this.resourceLocks.unlockTemporaryLockedObjects(transaction, destinationPath, lockOwner);
            }
        } else {
            resp.sendError(500);
            return false;
        }
    }

    private boolean shouldOverwrite(HttpServletRequest req) {
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        return overwrite;
    }

    private void copy(ITransaction transaction, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException {
        StoredObject sourceSo = this.store.getStoredObject(transaction, sourcePath);
        if (sourceSo == null) {
            resp.setStatus(404);
            return;
        }
        if (sourceSo.isResource()) {
            this.store.createResource(transaction, destinationPath);
            long resourceLength = this.store.setResourceContent(transaction, destinationPath, this.store.getResourceContent(transaction, sourcePath), null, null);
            if (resourceLength != -1L) {
                StoredObject destinationSo = this.store.getStoredObject(transaction, destinationPath);
                destinationSo.setResourceLength(resourceLength);
            }
        } else if (sourceSo.isFolder()) {
            this.copyFolder(transaction, sourcePath, destinationPath, errorList, req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void copyFolder(ITransaction transaction, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        this.store.createFolder(transaction, destinationPath);
        boolean infiniteDepth = true;
        String depth = req.getHeader("Depth");
        if (depth != null && depth.equals("0")) {
            infiniteDepth = false;
        }
        if (infiniteDepth) {
            String[] children = this.store.getChildrenNames(transaction, sourcePath);
            children = children == null ? new String[]{} : children;
            for (int i = children.length - 1; i >= 0; --i) {
                children[i] = "/" + children[i];
                try {
                    StoredObject childSo = this.store.getStoredObject(transaction, sourcePath + children[i]);
                    if (childSo == null) {
                        errorList.put(destinationPath + children[i], 404);
                        continue;
                    }
                    if (childSo.isResource()) {
                        this.store.createResource(transaction, destinationPath + children[i]);
                        long resourceLength = this.store.setResourceContent(transaction, destinationPath + children[i], this.store.getResourceContent(transaction, sourcePath + children[i]), null, null);
                        if (resourceLength == -1L) continue;
                        StoredObject destinationSo = this.store.getStoredObject(transaction, destinationPath + children[i]);
                        destinationSo.setResourceLength(resourceLength);
                        continue;
                    }
                    this.copyFolder(transaction, sourcePath + children[i], destinationPath + children[i], errorList, req, resp);
                    continue;
                }
                catch (AccessDeniedException e) {
                    errorList.put(destinationPath + children[i], 403);
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    errorList.put(destinationPath + children[i], 404);
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    errorList.put(destinationPath + children[i], 409);
                    continue;
                }
                catch (WebdavException e) {
                    errorList.put(destinationPath + children[i], 500);
                }
            }
        }
    }

    private String parseDestinationHeader(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return null;
        }
        int protocolIndex = (destinationPath = RequestUtil.URLDecode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = this.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        return destinationPath;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }
}

