/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.ObjectAlreadyExistsException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.AbstractMethod;
import org.modeshape.webdav.methods.DeterminableMethod;

public class DoHead
extends AbstractMethod {
    protected final String dftIndexFile;
    protected final IWebdavStore store;
    protected final String insteadOf404;
    protected final ResourceLocks resourceLocks;
    protected final IMimeTyper mimeTyper;
    protected final int contentLength;
    private static Logger LOG = Logger.getLogger(DoHead.class);

    public DoHead(IWebdavStore store, String dftIndexFile, String insteadOf404, ResourceLocks resourceLocks, IMimeTyper mimeTyper, int contentLengthHeader) {
        this.store = store;
        this.dftIndexFile = dftIndexFile;
        this.insteadOf404 = insteadOf404;
        this.resourceLocks = resourceLocks;
        this.mimeTyper = mimeTyper;
        this.contentLength = contentLengthHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        boolean bUriExists = false;
        String path = this.getRelativePath(req);
        LOG.trace("-- " + this.getClass().getName(), new Object[0]);
        StoredObject so = this.store.getStoredObject(transaction, path);
        if (so == null) {
            if (this.insteadOf404 != null && !this.insteadOf404.trim().equals("")) {
                path = this.insteadOf404;
                so = this.store.getStoredObject(transaction, this.insteadOf404);
            }
        } else {
            bUriExists = true;
        }
        if (so != null) {
            String tempLockOwner;
            if (so.isFolder()) {
                if (this.dftIndexFile != null && !this.dftIndexFile.trim().equals("")) {
                    resp.sendRedirect(resp.encodeRedirectURL(req.getRequestURI() + this.dftIndexFile));
                    return;
                }
            } else if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            if (this.resourceLocks.lock(transaction, path, tempLockOwner = "doGet" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) {
                try {
                    String eTagMatch = req.getHeader("If-None-Match");
                    if (eTagMatch != null && eTagMatch.equals(this.getETag(so))) {
                        resp.setStatus(304);
                        return;
                    }
                    if (so.isResource()) {
                        String mimeType;
                        if (path.endsWith("/") || path.endsWith("\\")) {
                            resp.sendError(404, req.getRequestURI());
                        }
                        long lastModified = so.getLastModified().getTime();
                        resp.setDateHeader("last-modified", lastModified);
                        String eTag = this.getETag(so);
                        resp.addHeader("ETag", eTag);
                        long resourceLength = so.getResourceLength();
                        if (this.contentLength == 1 && resourceLength > 0L) {
                            if (resourceLength <= Integer.MAX_VALUE) {
                                resp.setContentLength((int)resourceLength);
                            } else {
                                resp.setHeader("content-length", "" + resourceLength);
                            }
                        }
                        if ((mimeType = this.mimeTyper.getMimeType(transaction, path)) != null) {
                            resp.setContentType(mimeType);
                        } else {
                            int lastSlash = path.replace('\\', '/').lastIndexOf(47);
                            int lastDot = path.indexOf(".", lastSlash);
                            if (lastDot == -1) {
                                resp.setContentType("text/html");
                            }
                        }
                        this.doBody(transaction, resp, path);
                    }
                    this.folderBody(transaction, path, resp, req);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            this.folderBody(transaction, path, resp, req);
        }
        if (!bUriExists) {
            resp.setStatus(404);
        }
    }

    protected void folderBody(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
    }

    protected void doBody(ITransaction transaction, HttpServletResponse resp, String path) throws IOException {
    }
}

