/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoLock;
import org.modeshape.webdav.methods.DoMkcol;

public class DoMkcolTest
extends AbstractWebDAVTest {
    private static final String PARENT_PATH = "/parentCollection";
    private static final String MKCOL_PATH = "/parentCollection/makeCollection";

    @Test
    public void testMkcolIfReadOnlyIsTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoMkcol doMkcol = new DoMkcol(this.mockStore, (IResourceLocks)resLocks, true);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMkcolSuccess() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                StoredObject parentSo = DoMkcolTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(2.returnValue((Object)parentSo));
                Object mkcolSo = null;
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(2.returnValue(mkcolSo));
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).createFolder(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).setStatus(201);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoMkcol doMkcol = new DoMkcol(this.mockStore, (IResourceLocks)resLocks, false);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMkcolIfParentPathIsNoFolder() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                StoredObject parentSo = DoMkcolTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(3.returnValue((Object)parentSo));
                String methodsAllowed = "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND";
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).addHeader("Allow", methodsAllowed);
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).sendError(405);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoMkcol doMkcol = new DoMkcol(this.mockStore, (IResourceLocks)resLocks, false);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMkcolIfParentPathIsAFolderButObjectAlreadyExists() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                StoredObject parentSo = DoMkcolTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(4.returnValue((Object)parentSo));
                StoredObject mkcolSo = DoMkcolTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(4.returnValue((Object)mkcolSo));
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).addHeader("Allow", "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND, PUT");
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).sendError(405);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoMkcol doMkcol = new DoMkcol(this.mockStore, (IResourceLocks)resLocks, false);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMkcolIfParentFolderIsLockedWithRightLockToken() throws Exception {
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, PARENT_PATH, "owner", true, -1, 200, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, PARENT_PATH);
        final String rightLockToken = "(<opaquelocktoken:" + lo.getID() + ">)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("If");
                this.will(5.returnValue((Object)rightLockToken));
                StoredObject parentSo = DoMkcolTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(5.returnValue((Object)parentSo));
                Object mkcolSo = null;
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(5.returnValue(mkcolSo));
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).createFolder(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).setStatus(201);
            }
        });
        DoMkcol doMkcol = new DoMkcol(this.mockStore, (IResourceLocks)resLocks, false);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMkcolIfParentFolderIsLockedWithWrongLockToken() throws Exception {
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, PARENT_PATH, "owner", true, -1, 200, false);
        String wrongLockToken = "(<opaquelocktoken:aWrongLockToken>)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("If");
                this.will(6.returnValue((Object)"(<opaquelocktoken:aWrongLockToken>)"));
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).sendError(403);
            }
        });
        DoMkcol doMkcol = new DoMkcol(this.mockStore, (IResourceLocks)resLocks, false);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testMkcolOnALockNullResource() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                LockedObject lockNullResourceLo = null;
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).getLockedObjectByPath(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue(lockNullResourceLo));
                Object parentLo = null;
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).getLockedObjectByPath(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(7.returnValue(parentLo));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("User-Agent");
                this.will(7.returnValue((Object)"Goliath"));
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).lock((ITransaction)this.with(7.any(ITransaction.class)), (String)this.with(7.any(String.class)), (String)this.with(7.any(String.class)), this.with(7.any(Boolean.TYPE)), this.with(7.any(Integer.TYPE)), this.with(7.any(Integer.TYPE)), this.with(7.any(Boolean.TYPE)));
                this.will(7.returnValue((Object)true));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("If");
                this.will(7.returnValue(null));
                StoredObject lockNullResourceSo = null;
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue(lockNullResourceSo));
                StoredObject parentSo = null;
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(7.returnValue(parentSo));
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).createFolder(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                parentSo = DoMkcolTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue(lockNullResourceSo));
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).createResource(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                lockNullResourceSo = DoMkcolTest.this.initLockNullStoredObject();
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).setStatus(201);
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue((Object)lockNullResourceSo));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getInputStream();
                this.will(7.returnValue((Object)DoMkcolTest.this.exclusiveLockRequestStream()));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("Depth");
                this.will(7.returnValue((Object)"0"));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("Timeout");
                this.will(7.returnValue((Object)"Infinite"));
                ResourceLocks resLocks = (ResourceLocks)ResourceLocks.class.newInstance();
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).exclusiveLock(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH, "I'am the Lock Owner", 0, 604800);
                this.will(7.returnValue((Object)true));
                lockNullResourceLo = DoMkcolTest.this.initLockNullLockedObject(resLocks, DoMkcolTest.MKCOL_PATH);
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).getLockedObjectByPath(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue((Object)lockNullResourceLo));
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).getWriter();
                this.will(7.returnValue((Object)DoMkcolTest.this.getPrintWriter()));
                String loId = null;
                if (lockNullResourceLo != null) {
                    loId = lockNullResourceLo.getID();
                }
                String lockToken = "<opaquelocktoken:" + loId + ">";
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).addHeader("Lock-Token", lockToken);
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(7.any(ITransaction.class)), (String)this.with(7.any(String.class)), (String)this.with(7.any(String.class)));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)DoMkcolTest.MKCOL_PATH));
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).getLockedObjectByPath(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(7.returnValue(parentLo));
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).lock((ITransaction)this.with(7.any(ITransaction.class)), (String)this.with(7.any(String.class)), (String)this.with(7.any(String.class)), this.with(7.any(Boolean.TYPE)), this.with(7.any(Integer.TYPE)), this.with(7.any(Integer.TYPE)), this.with(7.any(Boolean.TYPE)));
                this.will(7.returnValue((Object)true));
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.PARENT_PATH);
                this.will(7.returnValue((Object)parentSo));
                ((IWebdavStore)this.one(DoMkcolTest.this.mockStore)).getStoredObject(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue((Object)lockNullResourceSo));
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).getLockedObjectByPath(DoMkcolTest.this.mockTransaction, DoMkcolTest.MKCOL_PATH);
                this.will(7.returnValue((Object)lockNullResourceLo));
                String ifHeaderLockToken = "(<locktoken:" + loId + ">)";
                ((HttpServletRequest)this.one(DoMkcolTest.this.mockReq)).getHeader("If");
                this.will(7.returnValue((Object)ifHeaderLockToken));
                String[] owners = lockNullResourceLo.getOwner();
                String owner = null;
                if (owners != null) {
                    owner = owners[0];
                }
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).unlock(DoMkcolTest.this.mockTransaction, loId, owner);
                this.will(7.returnValue((Object)true));
                ((HttpServletResponse)this.one(DoMkcolTest.this.mockRes)).setStatus(201);
                ((IResourceLocks)this.one(DoMkcolTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(7.any(ITransaction.class)), (String)this.with(7.any(String.class)), (String)this.with(7.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, this.mockResourceLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        DoMkcol doMkcol = new DoMkcol(this.mockStore, this.mockResourceLocks, false);
        doMkcol.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

