/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.webdav.IMethodExecutor;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.WebdavStatus;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.fromcatalina.URLEncoder;
import org.modeshape.webdav.fromcatalina.XMLWriter;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;

public abstract class AbstractMethod
implements IMethodExecutor {
    private static final ThreadLocal<DateFormat> thLastmodifiedDateFormat = new ThreadLocal();
    private static final ThreadLocal<DateFormat> thCreationDateFormat = new ThreadLocal();
    private static final ThreadLocal<DateFormat> thLocalDateFormat = new ThreadLocal();
    protected static URLEncoder URL_ENCODER = new URLEncoder();
    protected static final int INFINITY = 3;
    protected static final String CREATION_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected static final String LAST_MODIFIED_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String LOCAL_DATE_FORMAT = "dd/MM/yy' 'HH:mm:ss";
    protected static int BUF_SIZE;
    protected static final int DEFAULT_TIMEOUT = 3600;
    protected static final int MAX_TIMEOUT = 604800;
    protected static final boolean TEMPORARY = true;
    protected static final int TEMP_TIMEOUT = 10;

    public static String lastModifiedDateFormat(Date date) {
        DateFormat df = thLastmodifiedDateFormat.get();
        if (df == null) {
            df = new SimpleDateFormat(LAST_MODIFIED_DATE_FORMAT, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            thLastmodifiedDateFormat.set(df);
        }
        return df.format(date);
    }

    public static String creationDateFormat(Date date) {
        DateFormat df = thCreationDateFormat.get();
        if (df == null) {
            df = new SimpleDateFormat(CREATION_DATE_FORMAT);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            thCreationDateFormat.set(df);
        }
        return df.format(date);
    }

    public static String getLocalDateFormat(Date date, Locale loc) {
        DateFormat df = thLocalDateFormat.get();
        if (df == null) {
            df = new SimpleDateFormat(LOCAL_DATE_FORMAT, loc);
        }
        return df.format(date);
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null || result.equals("")) {
                result = "/";
            }
            return this.encodedResult(result);
        }
        String result = request.getPathInfo();
        if (result == null || result.equals("")) {
            result = "/";
        }
        return this.encodedResult(result);
    }

    private String encodedResult(String result) {
        try {
            return new String(result.getBytes(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    protected String getCleanPath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("jaxp failed");
        }
        return documentBuilder;
    }

    protected int getDepth(HttpServletRequest req) {
        int depth = 3;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null) {
            if (depthStr.equals("0")) {
                depth = 0;
            } else if (depthStr.equals("1")) {
                depth = 1;
            }
        }
        return depth;
    }

    protected String rewriteUrl(String path) {
        return URL_ENCODER.encode(path);
    }

    protected String getETag(StoredObject so) {
        String resourceLength = "";
        String lastModified = "";
        if (so != null && so.isResource()) {
            resourceLength = Long.toString(so.getResourceLength());
            lastModified = Long.toString(so.getLastModified().getTime());
        }
        return "W/\"" + resourceLength + "-" + lastModified + "\"";
    }

    protected String[] getLockIdFromIfHeader(HttpServletRequest req) {
        String[] ids = new String[2];
        String id = req.getHeader("If");
        if (id != null && !id.equals("")) {
            if (id.indexOf(">)") == id.lastIndexOf(">)")) {
                if ((id = id.substring(id.indexOf("(<"), id.indexOf(">)"))).contains("locktoken:")) {
                    id = id.substring(id.indexOf(58) + 1);
                }
                ids[0] = id;
            } else {
                String firstId = id.substring(id.indexOf("(<"), id.indexOf(">)"));
                if (firstId.contains("locktoken:")) {
                    firstId = firstId.substring(firstId.indexOf(58) + 1);
                }
                ids[0] = firstId;
                String secondId = id.substring(id.lastIndexOf("(<"), id.lastIndexOf(">)"));
                if (secondId.contains("locktoken:")) {
                    secondId = secondId.substring(secondId.indexOf(58) + 1);
                }
                ids[1] = secondId;
            }
        } else {
            ids = null;
        }
        return ids;
    }

    protected String getLockIdFromLockTokenHeader(HttpServletRequest req) {
        String id = req.getHeader("Lock-Token");
        if (id != null) {
            id = id.substring(id.indexOf(":") + 1, id.indexOf(">"));
        }
        return id;
    }

    protected boolean isUnlocked(ITransaction transaction, HttpServletRequest req, IResourceLocks resourceLocks, String path) throws IOException, LockFailedException {
        LockedObject resourceLock = resourceLocks.getLockedObjectByPath(transaction, path);
        if (resourceLock == null) {
            return true;
        }
        if (resourceLock.isShared()) {
            return false;
        }
        String[] requestLockTokens = this.getLockIdFromIfHeader(req);
        String requestLockToken = null;
        if (requestLockTokens != null) {
            requestLockToken = requestLockTokens[0];
            LockedObject lockedObjectByToken = resourceLocks.getLockedObjectByID(transaction, requestLockToken);
            return lockedObjectByToken != null && lockedObjectByToken.equals(resourceLock);
        }
        return false;
    }

    protected void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable<String, Integer> errorList) throws IOException {
        if (errorList.size() == 1) {
            int code = errorList.elements().nextElement();
            if (!StringUtil.isBlank((String)WebdavStatus.getStatusText(code))) {
                resp.sendError(code, WebdavStatus.getStatusText(code));
            } else {
                resp.sendError(code);
            }
        } else {
            resp.setStatus(207);
            String absoluteUri = req.getRequestURI();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("DAV:", "D");
            XMLWriter generatedXML = new XMLWriter(namespaces);
            generatedXML.writeXMLHeader();
            generatedXML.writeElement("DAV::multistatus", 0);
            Enumeration<String> pathList = errorList.keys();
            while (pathList.hasMoreElements()) {
                String errorPath = pathList.nextElement();
                int errorCode = errorList.get(errorPath);
                generatedXML.writeElement("DAV::response", 0);
                generatedXML.writeElement("DAV::href", 0);
                String toAppend = null;
                if (absoluteUri.endsWith(errorPath)) {
                    toAppend = absoluteUri;
                } else if (absoluteUri.contains(errorPath)) {
                    int endIndex = absoluteUri.indexOf(errorPath) + errorPath.length();
                    toAppend = absoluteUri.substring(0, endIndex);
                }
                if (toAppend != null && !toAppend.startsWith("/") && !toAppend.startsWith("http:")) {
                    toAppend = "/" + toAppend;
                }
                generatedXML.writeText(errorPath);
                generatedXML.writeElement("DAV::href", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::response", 1);
            }
            generatedXML.writeElement("DAV::multistatus", 1);
            PrintWriter writer = resp.getWriter();
            ((Writer)writer).write(generatedXML.toString());
            ((Writer)writer).close();
        }
    }

    static {
        URL_ENCODER.addSafeCharacter('-');
        URL_ENCODER.addSafeCharacter('_');
        URL_ENCODER.addSafeCharacter('.');
        URL_ENCODER.addSafeCharacter('*');
        URL_ENCODER.addSafeCharacter('/');
        BUF_SIZE = 65536;
    }
}

