/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.locking;

import java.util.UUID;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.locking.ResourceLocks;

public class LockedObject {
    private static final Logger LOGGER = Logger.getLogger(LockedObject.class);
    private ResourceLocks resourceLocks;
    private String path;
    private String id;
    protected int lockDepth;
    protected long expiresAt;
    protected String[] owner = null;
    protected LockedObject[] children = null;
    protected LockedObject parent = null;
    protected boolean exclusive = false;
    protected String type = null;

    public LockedObject(ResourceLocks resLocks, String path, boolean temporary) {
        this.path = path;
        this.id = UUID.randomUUID().toString();
        this.resourceLocks = resLocks;
        if (!temporary) {
            this.resourceLocks.locks.put(path, this);
            this.resourceLocks.locksByID.put(this.id, this);
        } else {
            this.resourceLocks.tempLocks.put(path, this);
            this.resourceLocks.tempLocksByID.put(this.id, this);
        }
        ++this.resourceLocks.cleanupCounter;
    }

    public boolean addLockedObjectOwner(String owner) {
        if (this.owner == null) {
            this.owner = new String[1];
        } else {
            int size = this.owner.length;
            String[] newLockObjectOwner = new String[size + 1];
            for (int i = 0; i < size; ++i) {
                if (!this.owner[i].equals(owner)) continue;
                return false;
            }
            System.arraycopy(this.owner, 0, newLockObjectOwner, 0, size);
            this.owner = newLockObjectOwner;
        }
        this.owner[this.owner.length - 1] = owner;
        return true;
    }

    public void removeLockedObjectOwner(String owner) {
        try {
            if (this.owner != null) {
                int size = this.owner.length;
                for (int i = 0; i < size; ++i) {
                    if (!this.owner[i].equals(owner)) continue;
                    String[] newLockedObjectOwner = new String[--size];
                    for (int j = 0; j < size; ++j) {
                        newLockedObjectOwner[j] = j < i ? this.owner[j] : this.owner[j + 1];
                    }
                    this.owner = newLockedObjectOwner;
                }
                if (this.owner.length == 0) {
                    this.owner = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.error((Throwable)e, (I18nResource)new TextI18n("LockedObject.removeLockedObjectOwner()"), new Object[0]);
        }
    }

    public void addChild(LockedObject newChild) {
        if (this.children == null) {
            this.children = new LockedObject[0];
        }
        int size = this.children.length;
        LockedObject[] newChildren = new LockedObject[size + 1];
        System.arraycopy(this.children, 0, newChildren, 0, size);
        newChildren[size] = newChild;
        this.children = newChildren;
    }

    public void removeLockedObject() {
        if (this != this.resourceLocks.root && !this.getPath().equals("/")) {
            int size = this.parent.children.length;
            for (int i = 0; i < size; ++i) {
                if (!this.parent.children[i].equals(this)) continue;
                LockedObject[] newChildren = new LockedObject[size - 1];
                for (int i2 = 0; i2 < size - 1; ++i2) {
                    newChildren[i2] = i2 < i ? this.parent.children[i2] : this.parent.children[i2 + 1];
                }
                if (newChildren.length != 0) {
                    this.parent.children = newChildren;
                    break;
                }
                this.parent.children = null;
                break;
            }
            this.resourceLocks.locksByID.remove(this.getID());
            this.resourceLocks.locks.remove(this.getPath());
        }
    }

    public void removeTempLockedObject() {
        if (this != this.resourceLocks.tempRoot && this.parent != null && this.parent.children != null) {
            int size = this.parent.children.length;
            for (int i = 0; i < size; ++i) {
                if (!this.parent.children[i].equals(this)) continue;
                LockedObject[] newChildren = new LockedObject[size - 1];
                for (int i2 = 0; i2 < size - 1; ++i2) {
                    newChildren[i2] = i2 < i ? this.parent.children[i2] : this.parent.children[i2 + 1];
                }
                if (newChildren.length != 0) {
                    this.parent.children = newChildren;
                    break;
                }
                this.parent.children = null;
                break;
            }
            this.resourceLocks.tempLocksByID.remove(this.getID());
            this.resourceLocks.tempLocks.remove(this.getPath());
        }
    }

    public boolean checkLocks(boolean exclusive, int depth) {
        return this.checkParents(exclusive) && this.checkChildren(exclusive, depth);
    }

    private boolean checkParents(boolean exclusive) {
        if (this.path.equals("/")) {
            return true;
        }
        if (this.owner == null) {
            return this.parent != null && this.parent.checkParents(exclusive);
        }
        return !this.exclusive && !exclusive && this.parent.checkParents(exclusive);
    }

    private boolean checkChildren(boolean exclusive, int depth) {
        if (this.children == null) {
            return this.owner == null || !this.exclusive && !exclusive;
        }
        if (this.owner == null) {
            if (depth != 0) {
                boolean canLock = true;
                int limit = this.children.length;
                for (int i = 0; i < limit; ++i) {
                    if (this.children[i].checkChildren(exclusive, depth - 1)) continue;
                    canLock = false;
                }
                return canLock;
            }
            return true;
        }
        return !this.exclusive && !exclusive;
    }

    public void refreshTimeout(int timeout) {
        this.expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
    }

    public long getTimeoutMillis() {
        return this.expiresAt - System.currentTimeMillis();
    }

    public boolean hasExpired() {
        if (this.expiresAt != 0L) {
            return System.currentTimeMillis() > this.expiresAt;
        }
        return true;
    }

    public String getID() {
        return this.id;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public String getPath() {
        return this.path;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isShared() {
        return !this.exclusive;
    }

    public String getType() {
        return this.type;
    }

    public int getLockDepth() {
        return this.lockDepth;
    }
}

