/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.WebdavException;

public class LocalFileSystemStore
implements IWebdavStore {
    private static Logger LOG = Logger.getLogger(LocalFileSystemStore.class);
    private static int BUF_SIZE = 65536;
    private File root = null;

    public LocalFileSystemStore(File root) {
        this.root = root;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ITransaction begin(Principal principal) throws WebdavException {
        LOG.trace("LocalFileSystemStore.begin()", new Object[0]);
        if (!this.root.exists() && !this.root.mkdirs()) {
            throw new WebdavException("root path: " + this.root.getAbsolutePath() + " does not exist and could not be created");
        }
        return null;
    }

    @Override
    public void checkAuthentication(ITransaction transaction) throws SecurityException {
        LOG.trace("LocalFileSystemStore.checkAuthentication()", new Object[0]);
    }

    @Override
    public void commit(ITransaction transaction) throws WebdavException {
        LOG.trace("LocalFileSystemStore.commit()", new Object[0]);
    }

    @Override
    public void rollback(ITransaction transaction) throws WebdavException {
        LOG.trace("LocalFileSystemStore.rollback()", new Object[0]);
    }

    @Override
    public void createFolder(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.createFolder(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        if (!file.mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    @Override
    public void createResource(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.createResource(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.createResource(" + uri + ") failed"), new Object[0]);
            throw new WebdavException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setResourceContent(ITransaction transaction, String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        LOG.trace("LocalFileSystemStore.setResourceContent(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), BUF_SIZE);
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    ((OutputStream)os).write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    is.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.setResourceContent(" + uri + ") failed"), new Object[0]);
            throw new WebdavException(e);
        }
        long length = -1L;
        try {
            length = file.length();
        }
        catch (SecurityException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.setResourceContent(" + uri + ") failed" + "\nCan't get file.length"), new Object[0]);
        }
        return length;
    }

    @Override
    public String[] getChildrenNames(ITransaction transaction, String uri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.getChildrenNames(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        String[] childrenNames = null;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            String name = null;
            for (int i = 0; i < children.length; ++i) {
                name = children[i].getName();
                childList.add(name);
                LOG.trace("Child " + i + ": " + name, new Object[0]);
            }
            childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
        }
        return childrenNames;
    }

    @Override
    public void removeObject(ITransaction transaction, String uri) throws WebdavException {
        File file = new File(this.root, uri);
        boolean success = file.delete();
        LOG.trace("LocalFileSystemStore.removeObject(" + uri + ")=" + success, new Object[0]);
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }

    @Override
    public InputStream getResourceContent(ITransaction transaction, String uri) throws WebdavException {
        BufferedInputStream in;
        LOG.trace("LocalFileSystemStore.getResourceContent(" + uri + ")", new Object[0]);
        File file = new File(this.root, uri);
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            LOG.error((I18nResource)new TextI18n("LocalFileSystemStore.getResourceContent(" + uri + ") failed"), new Object[0]);
            throw new WebdavException(e);
        }
        return in;
    }

    @Override
    public long getResourceLength(ITransaction transaction, String resourceUri) throws WebdavException {
        LOG.trace("LocalFileSystemStore.getResourceLength(" + resourceUri + ")", new Object[0]);
        File file = new File(this.root, resourceUri);
        return file.length();
    }

    @Override
    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        StoredObject so = null;
        File file = new File(this.root, uri);
        if (file.exists()) {
            so = new StoredObject();
            so.setFolder(file.isDirectory());
            so.setLastModified(new Date(file.lastModified()));
            so.setCreationDate(new Date(file.lastModified()));
            so.setResourceLength(this.getResourceLength(transaction, uri));
        }
        return so;
    }
}

