/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.fromcatalina;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuffer buffer = new StringBuffer();
    protected Writer writer = null;
    protected Map<String, String> namespaces;
    protected boolean isRootElement = true;

    public XMLWriter(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public XMLWriter(Writer writer, Map<String, String> namespaces) {
        this.writer = writer;
        this.namespaces = namespaces;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String name, String value) {
        this.writeElement(name, 0);
        this.buffer.append(value);
        this.writeElement(name, 1);
    }

    public void writeProperty(String name) {
        this.writeElement(name, 2);
    }

    public void writeElement(String name, int type) {
        int pos;
        StringBuffer nsdecl = new StringBuffer();
        if (this.isRootElement) {
            for (String fullName : this.namespaces.keySet()) {
                String abbrev = this.namespaces.get(fullName);
                nsdecl.append(" xmlns:").append(abbrev).append("=\"").append(fullName).append("\"");
            }
            this.isRootElement = false;
        }
        if ((pos = name.lastIndexOf(58)) >= 0) {
            String fullns = name.substring(0, pos);
            String prefix = this.namespaces.get(fullns);
            if (prefix == null && this.namespaces.containsValue(fullns)) {
                prefix = fullns;
            }
            if (prefix == null) {
                name = name.substring(pos + 1);
                nsdecl.append(" xmlns=\"").append(fullns).append("\"");
            } else {
                name = prefix + ":" + name.substring(pos + 1);
            }
        } else {
            throw new IllegalArgumentException("All XML elements must have a namespace");
        }
        switch (type) {
            case 0: {
                this.buffer.append("<" + name + nsdecl + ">");
                break;
            }
            case 1: {
                this.buffer.append("</" + name + ">\n");
                break;
            }
            default: {
                this.buffer.append("<" + name + nsdecl + "/>");
            }
        }
    }

    public void writeText(String text) {
        this.buffer.append(text);
    }

    public void writeData(String data) {
        this.buffer.append("<![CDATA[" + data + "]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.writer.flush();
            this.buffer = new StringBuffer();
        }
    }
}

