/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IMimeTyper;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoPropfind;

public class DoPropfindTest
extends AbstractWebDAVTest {
    @Test
    public void doPropFindOnDirectory() throws Exception {
        String path = "/";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getPathInfo();
                this.will(1.returnValue((Object)"/"));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getHeader("Depth");
                this.will(1.returnValue((Object)"infinity"));
                StoredObject rootSo = DoPropfindTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getCustomNamespaces(DoPropfindTest.this.mockTransaction, "/");
                this.will(1.returnValue(Collections.emptyMap()));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/");
                this.will(1.returnValue((Object)rootSo));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getPathInfo();
                this.will(1.returnValue((Object)"/"));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getContentLength();
                this.will(1.returnValue((Object)0));
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).setStatus(207);
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).getWriter();
                this.will(1.returnValue((Object)DoPropfindTest.this.getPrintWriter()));
                ((IMimeTyper)this.one(DoPropfindTest.this.mockMimeTyper)).getMimeType(DoPropfindTest.this.mockTransaction, "/");
                this.will(1.returnValue((Object)"text/xml; charset=UTF-8"));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/");
                this.will(1.returnValue((Object)rootSo));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getContextPath();
                this.will(1.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getServletPath();
                this.will(1.returnValue((Object)"/"));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getCustomProperties(DoPropfindTest.this.mockTransaction, "/");
                this.will(1.returnValue(Collections.emptyMap()));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getCustomProperties(DoPropfindTest.this.mockTransaction, "/file1");
                this.will(1.returnValue(Collections.emptyMap()));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getChildrenNames(DoPropfindTest.this.mockTransaction, "/");
                this.will(1.returnValue((Object)new String[]{"file1", "file2"}));
                StoredObject file1So = DoPropfindTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/file1");
                this.will(1.returnValue((Object)file1So));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getContextPath();
                this.will(1.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getServletPath();
                this.will(1.returnValue((Object)"/"));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getChildrenNames(DoPropfindTest.this.mockTransaction, "/file1");
                this.will(1.returnValue((Object)new String[0]));
                StoredObject file2So = DoPropfindTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/file2");
                this.will(1.returnValue((Object)file2So));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getContextPath();
                this.will(1.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getServletPath();
                this.will(1.returnValue((Object)"/"));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getChildrenNames(DoPropfindTest.this.mockTransaction, "/file2");
                this.will(1.returnValue((Object)new String[0]));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getCustomProperties(DoPropfindTest.this.mockTransaction, "/file2");
                this.will(1.returnValue(Collections.emptyMap()));
            }
        });
        DoPropfind doPropfind = new DoPropfind(this.mockStore, new ResourceLocks(), this.mockMimeTyper);
        doPropfind.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void doPropFindOnFile() throws Exception {
        String path = "/testFile";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/testFile"));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getHeader("Depth");
                this.will(2.returnValue((Object)"0"));
                StoredObject fileSo = DoPropfindTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getCustomNamespaces(DoPropfindTest.this.mockTransaction, "/testFile");
                this.will(2.returnValue(Collections.emptyMap()));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/testFile");
                this.will(2.returnValue((Object)fileSo));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/testFile"));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getContentLength();
                this.will(2.returnValue((Object)0));
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).setStatus(207);
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).getWriter();
                this.will(2.returnValue((Object)DoPropfindTest.this.getPrintWriter()));
                ((IMimeTyper)this.one(DoPropfindTest.this.mockMimeTyper)).getMimeType(DoPropfindTest.this.mockTransaction, "/testFile");
                this.will(2.returnValue((Object)"text/xml; charset=UTF-8"));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/testFile");
                this.will(2.returnValue((Object)fileSo));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getContextPath();
                this.will(2.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getServletPath();
                this.will(2.returnValue((Object)"/"));
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getCustomProperties(DoPropfindTest.this.mockTransaction, "/testFile");
                this.will(2.returnValue(Collections.emptyMap()));
            }
        });
        DoPropfind doPropfind = new DoPropfind(this.mockStore, new ResourceLocks(), this.mockMimeTyper);
        doPropfind.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void doPropFindOnNonExistingResource() throws Exception {
        String path = "/notExists";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/notExists"));
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getHeader("Depth");
                this.will(3.returnValue((Object)"0"));
                Object notExistingSo = null;
                ((IWebdavStore)this.one(DoPropfindTest.this.mockStore)).getStoredObject(DoPropfindTest.this.mockTransaction, "/notExists");
                this.will(3.returnValue(notExistingSo));
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletRequest)this.one(DoPropfindTest.this.mockReq)).getRequestURI();
                this.will(3.returnValue((Object)"/notExists"));
                ((HttpServletResponse)this.one(DoPropfindTest.this.mockRes)).sendError(404, "/notExists");
            }
        });
        DoPropfind doPropfind = new DoPropfind(this.mockStore, new ResourceLocks(), this.mockMimeTyper);
        doPropfind.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

