/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoDelete;

public class DoDeleteTest
extends AbstractWebDAVTest {
    @Test
    public void testDeleteIfReadOnlyIsTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, true);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFileIfObjectExists() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                StoredObject fileSo = DoDeleteTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(2.returnValue((Object)fileSo));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, new ResourceLocks(), false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFileIfObjectNotExists() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                Object fileSo = null;
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(3.returnValue(fileSo));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).sendError(404);
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, new ResourceLocks(), false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFolderIfObjectExists() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                StoredObject folderSo = DoDeleteTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(4.returnValue((Object)folderSo));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getChildrenNames(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(4.returnValue((Object)new String[]{"subFolder", "sourceFile"}));
                StoredObject fileSo = DoDeleteTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(4.returnValue((Object)fileSo));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                StoredObject subFolderSo = DoDeleteTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/subFolder");
                this.will(4.returnValue((Object)subFolderSo));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getChildrenNames(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/subFolder");
                this.will(4.returnValue((Object)new String[]{"fileInSubFolder"}));
                StoredObject fileInSubFolderSo = DoDeleteTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/subFolder/fileInSubFolder");
                this.will(4.returnValue((Object)fileInSubFolderSo));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/subFolder/fileInSubFolder");
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/subFolder");
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder");
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, new ResourceLocks(), false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFolderIfObjectNotExists() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(5.returnValue(null));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).sendError(404);
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, new ResourceLocks(), false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFileInFolder() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                StoredObject fileSo = DoDeleteTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(6.returnValue((Object)fileSo));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, new ResourceLocks(), false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFileInLockedFolderWithWrongLockToken() throws Exception {
        String lockedFolderPath = "/lockedFolder";
        String fileInLockedFolderPath = "/lockedFolder/fileInLockedFolder";
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/lockedFolder", "owner", true, -1, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/lockedFolder");
        final String wrongLockToken = "(<opaquelocktoken:" + lo.getID() + "WRONG>)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/lockedFolder/fileInLockedFolder"));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getHeader("If");
                this.will(7.returnValue((Object)wrongLockToken));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(423);
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFileInLockedFolderWithRightLockToken() throws Exception {
        String path = "/lockedFolder/fileInLockedFolder";
        String parentPath = "/lockedFolder";
        String owner = "owner";
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/lockedFolder", "owner", true, -1, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/lockedFolder");
        final String rightLockToken = "(<opaquelocktoken:" + lo.getID() + ">)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(8.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/lockedFolder/fileInLockedFolder"));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getHeader("If");
                this.will(8.returnValue((Object)rightLockToken));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                StoredObject so = DoDeleteTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/lockedFolder/fileInLockedFolder");
                this.will(8.returnValue((Object)so));
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).removeObject(DoDeleteTest.this.mockTransaction, "/lockedFolder/fileInLockedFolder");
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDeleteFileInFolderIfObjectNotExists() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(9.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoDeleteTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)"/folder/file"));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).setStatus(204);
                Object nonExistingSo = null;
                ((IWebdavStore)this.oneOf(DoDeleteTest.this.mockStore)).getStoredObject(DoDeleteTest.this.mockTransaction, "/folder/file");
                this.will(9.returnValue(nonExistingSo));
                ((HttpServletResponse)this.oneOf(DoDeleteTest.this.mockRes)).sendError(404);
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, new ResourceLocks(), false);
        doDelete.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

