/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.IResourceLocks;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoLock;

public class DoLockTest
extends AbstractWebDAVTest {
    private static final boolean EXCLUSIVE = true;
    private static final String DEPTH_STRING = "-1";
    private static final int DEPTH = -1;
    private static final String TIMEOUT_STRING = "10";

    @Test
    public void testDoLockIfReadOnly() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoLock doLock = new DoLock(this.mockStore, (IResourceLocks)resLocks, true);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoRefreshLockOnLockedResource() throws Exception {
        String lockPath = "/aFileToLock";
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/aFileToLock", "owner", true, -1, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/aFileToLock");
        String lockTokenString = lo.getID();
        final String lockToken = "(<opaquelocktoken:" + lockTokenString + ">)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/aFileToLock"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("If");
                this.will(2.returnValue((Object)lockToken));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("User-Agent");
                this.will(2.returnValue((Object)"Goliath"));
                ((HttpServletRequest)this.exactly(2).of((Object)DoLockTest.this.mockReq)).getHeader("If");
                this.will(2.returnValue((Object)lockToken));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Timeout");
                this.will(2.returnValue((Object)"Infinite"));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).getWriter();
                this.will(2.returnValue((Object)DoLockTest.this.getPrintWriter()));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).addHeader("Lock-Token", lockToken.substring(lockToken.indexOf("(") + 1, lockToken.indexOf(")")));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, (IResourceLocks)resLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoExclusiveLockOnResource() throws Exception {
        String lockPath = "/aFileToLock";
        ResourceLocks resLocks = new ResourceLocks();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/aFileToLock"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("User-Agent");
                this.will(3.returnValue((Object)"Goliath"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("If");
                this.will(3.returnValue(null));
                StoredObject so = DoLockTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, "/aFileToLock");
                this.will(3.returnValue((Object)so));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getInputStream();
                this.will(3.returnValue((Object)DoLockTest.this.exclusiveLockRequestStream()));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Depth");
                this.will(3.returnValue((Object)DoLockTest.DEPTH_STRING));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Timeout");
                this.will(3.returnValue((Object)DoLockTest.TIMEOUT_STRING));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).getWriter();
                this.will(3.returnValue((Object)DoLockTest.this.getPrintWriter()));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).addHeader((String)this.with(3.any(String.class)), (String)this.with(3.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, (IResourceLocks)resLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoSharedLockOnResource() throws Exception {
        String lockPath = "/aFileToLock";
        ResourceLocks resLocks = new ResourceLocks();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/aFileToLock"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("User-Agent");
                this.will(4.returnValue((Object)"Goliath"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("If");
                this.will(4.returnValue(null));
                StoredObject so = DoLockTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, "/aFileToLock");
                this.will(4.returnValue((Object)so));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getInputStream();
                this.will(4.returnValue((Object)DoLockTest.this.sharedLockRequestStream()));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Depth");
                this.will(4.returnValue((Object)DoLockTest.DEPTH_STRING));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Timeout");
                this.will(4.returnValue((Object)DoLockTest.TIMEOUT_STRING));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).getWriter();
                this.will(4.returnValue((Object)DoLockTest.this.getPrintWriter()));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).addHeader((String)this.with(4.any(String.class)), (String)this.with(4.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, (IResourceLocks)resLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoExclusiveLockOnCollection() throws Exception {
        String lockPath = "/aFolderToLock";
        ResourceLocks resLocks = new ResourceLocks();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/aFolderToLock"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("User-Agent");
                this.will(5.returnValue((Object)"Goliath"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("If");
                this.will(5.returnValue(null));
                StoredObject so = DoLockTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, "/aFolderToLock");
                this.will(5.returnValue((Object)so));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getInputStream();
                this.will(5.returnValue((Object)DoLockTest.this.exclusiveLockRequestStream()));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Depth");
                this.will(5.returnValue((Object)DoLockTest.DEPTH_STRING));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Timeout");
                this.will(5.returnValue((Object)DoLockTest.TIMEOUT_STRING));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).getWriter();
                this.will(5.returnValue((Object)DoLockTest.this.getPrintWriter()));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).addHeader((String)this.with(5.any(String.class)), (String)this.with(5.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, (IResourceLocks)resLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoSharedLockOnCollection() throws Exception {
        String lockPath = "/aFolderToLock";
        ResourceLocks resLocks = new ResourceLocks();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/aFolderToLock"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("User-Agent");
                this.will(6.returnValue((Object)"Goliath"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("If");
                this.will(6.returnValue(null));
                StoredObject so = DoLockTest.this.initFolderStoredObject();
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, "/aFolderToLock");
                this.will(6.returnValue((Object)so));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getInputStream();
                this.will(6.returnValue((Object)DoLockTest.this.sharedLockRequestStream()));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Depth");
                this.will(6.returnValue((Object)DoLockTest.DEPTH_STRING));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Timeout");
                this.will(6.returnValue((Object)DoLockTest.TIMEOUT_STRING));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).getWriter();
                this.will(6.returnValue((Object)DoLockTest.this.getPrintWriter()));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).addHeader((String)this.with(6.any(String.class)), (String)this.with(6.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, (IResourceLocks)resLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoLockNullResourceLock() throws Exception {
        String parentPath = "/parentCollection";
        final String lockPath = "/parentCollection".concat("/aNullResource");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)lockPath));
                LockedObject lockNullResourceLo = null;
                ((IResourceLocks)this.oneOf(DoLockTest.this.mockResourceLocks)).getLockedObjectByPath(DoLockTest.this.mockTransaction, lockPath);
                this.will(7.returnValue(lockNullResourceLo));
                Object parentLo = null;
                ((IResourceLocks)this.oneOf(DoLockTest.this.mockResourceLocks)).getLockedObjectByPath(DoLockTest.this.mockTransaction, "/parentCollection");
                this.will(7.returnValue(parentLo));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("User-Agent");
                this.will(7.returnValue((Object)"Goliath"));
                ((IResourceLocks)this.oneOf(DoLockTest.this.mockResourceLocks)).lock((ITransaction)this.with(7.any(ITransaction.class)), (String)this.with(7.any(String.class)), (String)this.with(7.any(String.class)), this.with(7.any(Boolean.TYPE)), this.with(7.any(Integer.TYPE)), this.with(7.any(Integer.TYPE)), this.with(7.any(Boolean.TYPE)));
                this.will(7.returnValue((Object)true));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("If");
                this.will(7.returnValue(null));
                StoredObject lockNullResourceSo = null;
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, lockPath);
                this.will(7.returnValue(lockNullResourceSo));
                Object parentSo = null;
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, "/parentCollection");
                this.will(7.returnValue(parentSo));
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).createFolder(DoLockTest.this.mockTransaction, "/parentCollection");
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, lockPath);
                this.will(7.returnValue(lockNullResourceSo));
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).createResource(DoLockTest.this.mockTransaction, lockPath);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(201);
                lockNullResourceSo = DoLockTest.this.initLockNullStoredObject();
                ((IWebdavStore)this.oneOf(DoLockTest.this.mockStore)).getStoredObject(DoLockTest.this.mockTransaction, lockPath);
                this.will(7.returnValue((Object)lockNullResourceSo));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getInputStream();
                this.will(7.returnValue((Object)DoLockTest.this.exclusiveLockRequestStream()));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Depth");
                this.will(7.returnValue((Object)"0"));
                ((HttpServletRequest)this.oneOf(DoLockTest.this.mockReq)).getHeader("Timeout");
                this.will(7.returnValue((Object)"Infinite"));
                ResourceLocks resLocks = (ResourceLocks)ResourceLocks.class.newInstance();
                ((IResourceLocks)this.oneOf(DoLockTest.this.mockResourceLocks)).exclusiveLock(DoLockTest.this.mockTransaction, lockPath, "I'am the Lock Owner", 0, 604800);
                this.will(7.returnValue((Object)true));
                lockNullResourceLo = DoLockTest.this.initLockNullLockedObject(resLocks, lockPath);
                ((IResourceLocks)this.oneOf(DoLockTest.this.mockResourceLocks)).getLockedObjectByPath(DoLockTest.this.mockTransaction, lockPath);
                this.will(7.returnValue((Object)lockNullResourceLo));
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setStatus(200);
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).setContentType("text/xml; charset=UTF-8");
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).getWriter();
                this.will(7.returnValue((Object)DoLockTest.this.getPrintWriter()));
                String loId = null;
                if (lockNullResourceLo != null) {
                    loId = lockNullResourceLo.getID();
                }
                String lockToken = "<opaquelocktoken:" + loId + ">";
                ((HttpServletResponse)this.oneOf(DoLockTest.this.mockRes)).addHeader("Lock-Token", lockToken);
                ((IResourceLocks)this.oneOf(DoLockTest.this.mockResourceLocks)).unlockTemporaryLockedObjects((ITransaction)this.with(7.any(ITransaction.class)), (String)this.with(7.any(String.class)), (String)this.with(7.any(String.class)));
            }
        });
        DoLock doLock = new DoLock(this.mockStore, this.mockResourceLocks, false);
        doLock.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

